/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImporterClient;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperty;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import util.Clock;
import util.RegexTestCase;
import util.XmlUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class WikiImporterTest
extends RegexTestCase
implements WikiImporterClient {
    public WikiPage pageOne;
    public WikiPage childPageOne;
    public WikiPage pageTwo;
    public WikiPage remoteRoot;
    private WikiImporter importer;
    private LinkedList<WikiPage> imports;
    private LinkedList<Exception> errors;
    public WikiPage localRoot;

    public void setUp() throws Exception {
        this.createRemoteRoot();
        this.createLocalRoot();
        FitNesseUtil.startFitnesse((WikiPage)this.remoteRoot);
        this.importer = new WikiImporter();
        this.importer.setWikiImporterClient((WikiImporterClient)this);
        this.importer.parseUrl("http://localhost:1999");
        this.imports = new LinkedList();
        this.errors = new LinkedList();
    }

    public void createLocalRoot() throws Exception {
        this.localRoot = InMemoryPage.makeRoot((String)"RooT2");
        this.pageOne = this.localRoot.addChildPage("PageOne");
        this.childPageOne = this.pageOne.addChildPage("ChildOne");
        this.pageTwo = this.localRoot.addChildPage("PageTwo");
    }

    public WikiPage createRemoteRoot() throws Exception {
        this.remoteRoot = InMemoryPage.makeRoot((String)"RooT");
        PageCrawler crawler = this.remoteRoot.getPageCrawler();
        crawler.addPage(this.remoteRoot, PathParser.parse((String)"PageOne"), "page one");
        crawler.addPage(this.remoteRoot, PathParser.parse((String)"PageOne.ChildOne"), "child one");
        crawler.addPage(this.remoteRoot, PathParser.parse((String)"PageTwo"), "page two");
        return this.remoteRoot;
    }

    public void tearDown() throws Exception {
        FitNesseUtil.stopFitnesse();
    }

    public void testEnterChildPage() throws Exception {
        this.importer.enterChildPage(this.pageOne, Clock.currentDate());
        PageData data = this.pageOne.getData();
        WikiImporterTest.assertEquals((String)"page one", (String)data.getContent());
    }

    public void testChildPageAdded() throws Exception {
        this.importer.enterChildPage(this.pageOne, Clock.currentDate());
        this.importer.enterChildPage(this.childPageOne, Clock.currentDate());
        PageData data = this.childPageOne.getData();
        WikiImporterTest.assertEquals((String)"child one", (String)data.getContent());
    }

    public void testEnterChildPageWhenRemotePageNotModified() throws Exception {
        this.importer.enterChildPage(this.pageOne, Clock.currentDate());
        this.importer.exitPage();
        PageData data = this.pageOne.getData();
        data.setContent("new content");
        this.pageOne.commit(data);
        this.importer.enterChildPage(this.pageOne, new Date(0L));
        WikiImporterTest.assertEquals((String)"new content", (String)this.pageOne.getData().getContent());
    }

    public void testExiting() throws Exception {
        this.importer.enterChildPage(this.pageOne, Clock.currentDate());
        this.importer.enterChildPage(this.childPageOne, Clock.currentDate());
        this.importer.exitPage();
        this.importer.exitPage();
        this.importer.enterChildPage(this.pageTwo, Clock.currentDate());
        PageData data = this.pageTwo.getData();
        WikiImporterTest.assertEquals((String)"page two", (String)data.getContent());
    }

    public void testGetPageTree() throws Exception {
        Document doc = this.importer.getPageTree();
        WikiImporterTest.assertNotNull((Object)doc);
        String xml = XmlUtil.xmlAsString((Document)doc);
        WikiImporterTest.assertSubString((String)"PageOne", (String)xml);
        WikiImporterTest.assertSubString((String)"PageTwo", (String)xml);
    }

    public void testUrlParsing() throws Exception {
        this.testUrlParsing("http://mysite.com", "mysite.com", 80, "");
        this.testUrlParsing("http://mysite.com/", "mysite.com", 80, "");
        this.testUrlParsing("http://mysite.com:8080/", "mysite.com", 8080, "");
        this.testUrlParsing("http://mysite.com:8080", "mysite.com", 8080, "");
        this.testUrlParsing("http://mysite.com:80/", "mysite.com", 80, "");
        this.testUrlParsing("http://mysite.com/PageOne", "mysite.com", 80, "PageOne");
        this.testUrlParsing("http://mysite.com/PageOne.ChildOne", "mysite.com", 80, "PageOne.ChildOne");
    }

    private void testUrlParsing(String url, String host, int port, String path) throws Exception {
        this.importer.parseUrl(url);
        WikiImporterTest.assertEquals((String)host, (String)this.importer.getRemoteHostname());
        WikiImporterTest.assertEquals((int)port, (int)this.importer.getRemotePort());
        WikiImporterTest.assertEquals((String)path, (String)PathParser.render((WikiPagePath)this.importer.getRemotePath()));
    }

    public void testParsingBadUrl() throws Exception {
        try {
            this.importer.parseUrl("blah");
            WikiImporterTest.fail((String)"should have exception");
        }
        catch (Exception e) {
            WikiImporterTest.assertEquals((String)"blah is not a valid URL.", (String)e.getMessage());
        }
    }

    public void testParsingUrlWithNonWikiWord() throws Exception {
        try {
            this.importer.parseUrl("http://blah.com/notawikiword");
            WikiImporterTest.fail((String)"should throw exception");
        }
        catch (Exception e) {
            WikiImporterTest.assertEquals((String)"The URL's resource path, notawikiword, is not a valid WikiWord.", (String)e.getMessage());
        }
    }

    public void testImportingWiki() throws Exception {
        this.localRoot = InMemoryPage.makeRoot((String)"LocalRoot");
        this.importer.importWiki(this.localRoot);
        WikiImporterTest.assertEquals((int)2, (int)this.localRoot.getChildren().size());
        WikiImporterTest.assertEquals((int)3, (int)this.imports.size());
        WikiImporterTest.assertEquals((int)0, (int)this.errors.size());
    }

    public void testFindsOrphansOnLocalWiki() throws Exception {
        this.performImportWithExtraLocalPages();
        List orphans = this.importer.getOrphans();
        WikiImporterTest.assertEquals((int)3, (int)orphans.size());
        WikiImporterTest.assertTrue((boolean)orphans.contains(new WikiPagePath().addNameToEnd("PageThree")));
        WikiImporterTest.assertTrue((boolean)orphans.contains(new WikiPagePath().addNameToEnd("PageOne").addNameToEnd("ChildTwo")));
        WikiImporterTest.assertTrue((boolean)orphans.contains(new WikiPagePath().addNameToEnd("PageOne").addNameToEnd("ChildOne").addNameToEnd("GrandChildOne")));
        WikiImporterTest.assertFalse((boolean)orphans.contains(new WikiPagePath().addNameToEnd("PageThatDoesntImport")));
        WikiImporterTest.assertFalse((boolean)orphans.contains(new WikiPagePath().addNameToEnd("OtherImportRoot")));
    }

    private void performImportWithExtraLocalPages() throws Exception {
        this.addLocalPageWithImportProperty(this.localRoot, "PageThree", false);
        this.addLocalPageWithImportProperty(this.pageOne, "ChildTwo", false);
        this.addLocalPageWithImportProperty(this.childPageOne, "GrandChildOne", false);
        this.localRoot.addChildPage("PageThatDoesntImport");
        this.addLocalPageWithImportProperty(this.localRoot, "OtherImportRoot", true);
        this.importer.importWiki(this.localRoot);
    }

    public void testOrphansAreRemoved() throws Exception {
        this.performImportWithExtraLocalPages();
        WikiImporterTest.assertFalse((boolean)this.localRoot.hasChildPage("PageThree"));
        WikiImporterTest.assertFalse((boolean)this.pageOne.hasChildPage("ChildTwo"));
        WikiImporterTest.assertFalse((boolean)this.childPageOne.hasChildPage("GrandChildOne"));
        WikiImporterTest.assertTrue((boolean)this.localRoot.hasChildPage("PageThatDoesntImport"));
        WikiImporterTest.assertTrue((boolean)this.localRoot.hasChildPage("OtherImportRoot"));
    }

    public void testWholeTreeOrphaned() throws Exception {
        this.importer.importWiki(this.localRoot);
        this.remoteRoot.removeChildPage("PageOne");
        this.importer.importWiki(this.localRoot);
        WikiImporterTest.assertFalse((boolean)this.localRoot.hasChildPage("PageOne"));
    }

    public void testContextIsNotOrphanWhenUpdatingNonRoot() throws Exception {
        this.addLocalPageWithImportProperty(this.localRoot, "PageOne", false);
        this.importer.parseUrl("http://localhost:1999/PageOne");
        this.importer.importWiki(this.localRoot.getChildPage("PageOne"));
        WikiImporterTest.assertEquals((int)0, (int)this.importer.getOrphans().size());
    }

    public void testAutoUpdatePropertySetOnRoot() throws Exception {
        this.addLocalPageWithImportProperty(this.localRoot, "PageOne", false);
        this.importer.parseUrl("http://localhost:1999/PageOne");
        this.importer.setAutoUpdateSetting(true);
        WikiPage importedPage = this.localRoot.getChildPage("PageOne");
        this.importer.importWiki(importedPage);
        WikiImportProperty importProp = WikiImportProperty.createFrom((WikiPageProperty)importedPage.getData().getProperties());
        WikiImporterTest.assertTrue((boolean)importProp.isAutoUpdate());
        this.importer.setAutoUpdateSetting(false);
        this.importer.importWiki(importedPage);
        importProp = WikiImportProperty.createFrom((WikiPageProperty)importedPage.getData().getProperties());
        WikiImporterTest.assertFalse((boolean)importProp.isAutoUpdate());
    }

    public void testAutoUpdate_NewPage() throws Exception {
        this.importer.setAutoUpdateSetting(true);
        this.importer.enterChildPage(this.pageOne, Clock.currentDate());
        WikiImportProperty importProps = WikiImportProperty.createFrom((WikiPageProperty)this.pageOne.getData().getProperties());
        WikiImporterTest.assertTrue((boolean)importProps.isAutoUpdate());
    }

    public void testAutoUpdateWhenRemotePageNotModified() throws Exception {
        this.importer.enterChildPage(this.pageOne, Clock.currentDate());
        this.importer.exitPage();
        PageData data = this.pageOne.getData();
        data.setContent("new content");
        this.pageOne.commit(data);
        this.importer.setAutoUpdateSetting(true);
        this.importer.enterChildPage(this.pageOne, new Date(0L));
        WikiImportProperty importProps = WikiImportProperty.createFrom((WikiPageProperty)this.pageOne.getData().getProperties());
        WikiImporterTest.assertTrue((boolean)importProps.isAutoUpdate());
    }

    private WikiPage addLocalPageWithImportProperty(WikiPage parentPage, String pageName, boolean isRoot) throws Exception {
        WikiPage page = parentPage.addChildPage(pageName);
        PageData data = page.getData();
        WikiPagePath pagePath = this.localRoot.getPageCrawler().getFullPath(page);
        WikiImportProperty importProps = new WikiImportProperty("http://localhost:1999/" + PathParser.render((WikiPagePath)pagePath));
        if (isRoot) {
            importProps.setRoot(true);
        }
        importProps.addTo((WikiPageProperty)data.getProperties());
        page.commit(data);
        return page;
    }

    public void pageImported(WikiPage page) {
        this.imports.add(page);
    }

    public void pageImportError(WikiPage page, Exception e) {
        this.errors.add(e);
    }
}

