/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.editing.PropertiesResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import org.json.JSONObject;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class PropertiesResponderTest
extends RegexTestCase {
    private FitNesseContext context;
    private WikiPage root;
    private PageCrawler crawler;
    private MockRequest request;
    private Responder responder;
    private String content;

    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.request = new MockRequest();
    }

    public void testResponse() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"PageOne"));
        PageData data = page.getData();
        data.setContent("some content");
        WikiPageProperties properties = data.getProperties();
        properties.set("Suites", "Page Tags");
        properties.set("Test", "true");
        page.commit(data);
        MockRequest request = new MockRequest();
        request.setResource("PageOne");
        PropertiesResponder responder = new PropertiesResponder();
        SimpleResponse response = (SimpleResponse)responder.makeResponse(this.context, (Request)request);
        PropertiesResponderTest.assertEquals((String)"max-age=0", (String)response.getHeader("Cache-Control"));
        String content = response.getContent();
        PropertiesResponderTest.assertSubString((String)"PageOne", (String)content);
        PropertiesResponderTest.assertDoesntHaveRegexp((String)"textarea name=\"extensionXml\"", (String)content);
        PropertiesResponderTest.assertHasRegexp((String)"<input.*value=\"Save Properties\".*>", (String)content);
        PropertiesResponderTest.assertHasRegexp((String)"<input.*value=\"saveProperties\"", (String)content);
        PropertiesResponderTest.assertSubString((String)"<h5> Page Tags</h5>", (String)content);
        for (String attribute : new String[]{"Search", "Edit", "Properties", "Versions", "Refactor", "WhereUsed", "RecentChanges"}) {
            this.assertCheckboxChecked(attribute, content);
        }
        for (String attribute : new String[]{"Prune", "secure-read", "secure-write", "secure-test"}) {
            this.assertCheckboxNotChecked(content, attribute);
        }
    }

    private void assertCheckboxNotChecked(String content, String attribute) {
        PropertiesResponderTest.assertSubString((String)("<input type=\"checkbox\" id=\"" + attribute + "\" name=\"" + attribute + "\"/>"), (String)content);
    }

    private void assertCheckboxChecked(String attribute, String content) {
        PropertiesResponderTest.assertSubString((String)("<input type=\"checkbox\" id=\"" + attribute + "\" name=\"" + attribute + "\" checked=\"checked\"/>"), (String)content);
    }

    public void testJsonResponse() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"PageOne"));
        PageData data = page.getData();
        data.setContent("some content");
        WikiPageProperties properties = data.getProperties();
        properties.set("Test", "true");
        page.commit(data);
        MockRequest request = new MockRequest();
        request.setResource("PageOne");
        request.addInput("format", (Object)"json");
        PropertiesResponder responder = new PropertiesResponder();
        SimpleResponse response = (SimpleResponse)responder.makeResponse(this.context, (Request)request);
        PropertiesResponderTest.assertEquals((String)"text/json", (String)response.getContentType());
        String jsonText = response.getContent();
        JSONObject jsonObject = new JSONObject(jsonText);
        PropertiesResponderTest.assertTrue((boolean)jsonObject.getBoolean("Test"));
        PropertiesResponderTest.assertTrue((boolean)jsonObject.getBoolean("Search"));
        PropertiesResponderTest.assertTrue((boolean)jsonObject.getBoolean("Edit"));
        PropertiesResponderTest.assertTrue((boolean)jsonObject.getBoolean("Properties"));
        PropertiesResponderTest.assertTrue((boolean)jsonObject.getBoolean("Versions"));
        PropertiesResponderTest.assertTrue((boolean)jsonObject.getBoolean("Refactor"));
        PropertiesResponderTest.assertTrue((boolean)jsonObject.getBoolean("WhereUsed"));
        PropertiesResponderTest.assertTrue((boolean)jsonObject.getBoolean("RecentChanges"));
        PropertiesResponderTest.assertFalse((boolean)jsonObject.getBoolean("Suite"));
        PropertiesResponderTest.assertFalse((boolean)jsonObject.getBoolean("Prune"));
        PropertiesResponderTest.assertFalse((boolean)jsonObject.getBoolean("secure-read"));
        PropertiesResponderTest.assertFalse((boolean)jsonObject.getBoolean("secure-write"));
        PropertiesResponderTest.assertFalse((boolean)jsonObject.getBoolean("secure-test"));
    }

    public void testUsernameDisplayed() throws Exception {
        WikiPage page = this.getContentFromSimplePropertiesPage();
        PropertiesResponderTest.assertSubString((String)"Last modified anonymously", (String)this.content);
        PageData data = page.getData();
        data.setAttribute("LastModifyingUser", "Bill");
        page.commit(data);
        this.request.setResource("SomePage");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        this.content = response.getContent();
        PropertiesResponderTest.assertSubString((String)"Last modified by Bill", (String)this.content);
    }

    private WikiPage getContentFromSimplePropertiesPage() throws Exception {
        WikiPage page = this.root.addChildPage("SomePage");
        return this.getPropertiesContentFromPage(page);
    }

    private WikiPage getPropertiesContentFromPage(WikiPage page) throws Exception {
        this.request = new MockRequest();
        this.request.setResource(page.getName());
        this.responder = new PropertiesResponder();
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        this.content = response.getContent();
        return page;
    }

    public void testWikiImportForm() throws Exception {
        this.getContentFromSimplePropertiesPage();
        this.checkUpdateForm();
        PropertiesResponderTest.assertSubString((String)"Wiki Import", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"value=\"Import\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"type=\"text\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"name=\"remoteUrl\"", (String)this.content);
    }

    private void checkUpdateForm() {
        PropertiesResponderTest.assertSubString((String)"<form", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"action=\"\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<input", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"type=\"hidden\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"name=\"responder\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"value=\"import\"", (String)this.content);
    }

    public void testWikiImportUpdate() throws Exception {
        WikiImportProperty property = new WikiImportProperty("http://my.host.com/PageRoot");
        property.setRoot(true);
        this.testWikiImportUpdateWith(property);
        PropertiesResponderTest.assertSubString((String)"imports its subpages from", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"value=\"Update Subpages\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"Automatically update imported content when executing tests", (String)this.content);
    }

    public void testWikiImportUpdateNonroot() throws Exception {
        this.testWikiImportUpdateWith(new WikiImportProperty("http://my.host.com/PageRoot"));
        PropertiesResponderTest.assertSubString((String)"imports its content and subpages from", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"value=\"Update Content and Subpages\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"Automatically update imported content when executing tests", (String)this.content);
    }

    private void testWikiImportUpdateWith(WikiImportProperty property) throws Exception {
        WikiPage page = this.root.addChildPage("SomePage");
        PageData data = page.getData();
        property.addTo((WikiPageProperty)data.getProperties());
        page.commit(data);
        this.getPropertiesContentFromPage(page);
        this.checkUpdateForm();
        PropertiesResponderTest.assertSubString((String)"Wiki Import Update", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<a href=\"http://my.host.com/PageRoot\">http://my.host.com/PageRoot</a>", (String)this.content);
        PropertiesResponderTest.assertNotSubString((String)"value=\"Import\"", (String)this.content);
    }

    public void testSymbolicLinkForm() throws Exception {
        this.getContentFromSimplePropertiesPage();
        PropertiesResponderTest.assertSubString((String)"Symbolic Links", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<input type=\"hidden\" name=\"responder\" value=\"symlink\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<input type=\"text\" name=\"linkName\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<input type=\"text\" name=\"linkPath\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<input type=\"submit\" name=\"submit\" value=\"Create/Replace\"", (String)this.content);
    }

    public void testSymbolicLinkListing() throws Exception {
        WikiPage page = this.root.addChildPage("SomePage");
        page.addChildPage("SomeChild");
        WikiPage pageOne = this.root.addChildPage("PageOne");
        pageOne.addChildPage("ChildOne");
        PageData data = page.getData();
        WikiPageProperties props = data.getProperties();
        WikiPageProperty symProp = props.set("SymbolicLinks");
        symProp.set("InternalAbsPage", ".PageOne.ChildOne");
        symProp.set("InternalRelPage", "PageOne.ChildOne");
        symProp.set("InternalSubPage", ">SomeChild");
        symProp.set("ExternalPage", "file://some/page");
        page.commit(data);
        this.getPropertiesContentFromPage(page);
        PropertiesResponderTest.assertSubString((String)"<input type=\"text\" name=\"InternalAbsPage\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<a href=\".PageOne.ChildOne\">.PageOne.ChildOne</a>", (String)this.content);
        PropertiesResponderTest.assertMatches((String)"<a href=\".*\">Rename</a>", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<input type=\"text\" name=\"InternalRelPage\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<a href=\".PageOne.ChildOne\">PageOne.ChildOne</a>", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<input type=\"text\" name=\"InternalSubPage\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<a href=\".SomePage.SomeChild\">&gt;SomeChild</a>", (String)this.content);
        PropertiesResponderTest.assertHasRegexp((String)"<td>\\W*file://some/page\\W*</td>", (String)this.content);
    }

    public void testSymbolicLinkListingForBackwardPath() throws Exception {
        WikiPage page = this.root.addChildPage("SomePage");
        WikiPage child = page.addChildPage("SomeChild");
        page.addChildPage("OtherChild");
        PageData data = child.getData();
        WikiPageProperties props = data.getProperties();
        WikiPageProperty symProp = props.set("SymbolicLinks");
        symProp.set("InternalBackPage", "<SomePage.OtherChild");
        page.commit(data);
        this.getPropertiesContentFromPage(page);
        PropertiesResponderTest.assertSubString((String)"InternalBackPage", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<a href=\".SomePage.OtherChild\">&lt;SomePage.OtherChild</a>", (String)this.content);
    }

    public void testPageTypePropertiesHtml() throws Exception {
        WikiPage page = this.root.addChildPage("SomePage");
        PageData data = page.getData();
        SimpleResponse response = (SimpleResponse)new PropertiesResponder().makeResponse(this.context, (Request)this.request);
        String html = response.getContent();
        PropertiesResponderTest.assertSubString((String)"Page type:", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"radio\" id=\"Static\" name=\"PageType\" value=\"Static\" checked=\"checked\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"radio\" id=\"Test\" name=\"PageType\" value=\"Test\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"radio\" id=\"Suite\" name=\"PageType\" value=\"Suite\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"Prune\" name=\"Prune\"/>", (String)html);
    }

    public void testPageTypePropertiesSuiteHtml() throws Exception {
        WikiPage page = this.root.addChildPage("SomePage");
        PageData data = page.getData();
        data.setAttribute("Suite");
        page.commit(data);
        PropertiesResponderTest.assertSame((Object)page, (Object)this.context.root.getPageCrawler().getPage(this.context.root, PathParser.parse((String)".SomePage")));
        this.request.setResource(page.getPageCrawler().getFullPath(page).toString());
        SimpleResponse response = (SimpleResponse)new PropertiesResponder().makeResponse(this.context, (Request)this.request);
        String html = response.getContent();
        PropertiesResponderTest.assertSubString((String)"Page type:", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"radio\" id=\"Static\" name=\"PageType\" value=\"Static\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"radio\" id=\"Test\" name=\"PageType\" value=\"Test\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"radio\" id=\"Suite\" name=\"PageType\" value=\"Suite\" checked=\"checked\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"Prune\" name=\"Prune\"/>", (String)html);
    }

    public void testPageTypePropertiesTestHtml() throws Exception {
        WikiPage page = this.root.addChildPage("SomePage");
        PageData data = page.getData();
        data.setAttribute("Test");
        page.commit(data);
        this.request.setResource(page.getPageCrawler().getFullPath(page).toString());
        SimpleResponse response = (SimpleResponse)new PropertiesResponder().makeResponse(this.context, (Request)this.request);
        String html = response.getContent();
        PropertiesResponderTest.assertSubString((String)"Page type:", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"radio\" id=\"Static\" name=\"PageType\" value=\"Static\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"radio\" id=\"Test\" name=\"PageType\" value=\"Test\" checked=\"checked\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"radio\" id=\"Suite\" name=\"PageType\" value=\"Suite\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"Prune\" name=\"Prune\"/>", (String)html);
    }

    public void testPageTypePropertiesSkippedHtml() throws Exception {
        WikiPage page = this.root.addChildPage("SomePage");
        PageData data = page.getData();
        data.setAttribute("Prune");
        page.commit(data);
        this.request.setResource(page.getPageCrawler().getFullPath(page).toString());
        SimpleResponse response = (SimpleResponse)new PropertiesResponder().makeResponse(this.context, (Request)this.request);
        String html = response.getContent();
        PropertiesResponderTest.assertSubString((String)"Page type:", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"Prune\" name=\"Prune\" checked=\"checked\"/>", (String)html);
    }

    public void testActionPropertiesHtml() throws Exception {
        SimpleResponse response = (SimpleResponse)new PropertiesResponder().makeResponse(this.context, (Request)this.request);
        String html = response.getContent();
        PropertiesResponderTest.assertSubString((String)"Actions:", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"Edit\" name=\"Edit\" checked=\"checked\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"Versions\" name=\"Versions\" checked=\"checked\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"Properties\" name=\"Properties\" checked=\"checked\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"Refactor\" name=\"Refactor\" checked=\"checked\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"WhereUsed\" name=\"WhereUsed\" checked=\"checked\"/>", (String)html);
    }

    public void testMakeNavigationPropertiesHtml() throws Exception {
        WikiPage page = this.root.addChildPage("SomePage");
        PageData data = page.getData();
        SimpleResponse response = (SimpleResponse)new PropertiesResponder().makeResponse(this.context, (Request)this.request);
        String html = response.getContent();
        PropertiesResponderTest.assertSubString((String)"Navigation:", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"Files\" name=\"Files\" checked=\"checked\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"RecentChanges\" name=\"RecentChanges\" checked=\"checked\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"Search\" name=\"Search\" checked=\"checked\"/>", (String)html);
    }

    public void testMakeSecurityPropertiesHtml() throws Exception {
        WikiPage page = this.root.addChildPage("SomePage");
        PageData data = page.getData();
        SimpleResponse response = (SimpleResponse)new PropertiesResponder().makeResponse(this.context, (Request)this.request);
        String html = response.getContent();
        PropertiesResponderTest.assertSubString((String)"Security:", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"secure-read\" name=\"secure-read\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"secure-write\" name=\"secure-write\"/>", (String)html);
        PropertiesResponderTest.assertSubString((String)"<input type=\"checkbox\" id=\"secure-test\" name=\"secure-test\"/>", (String)html);
    }

    public void testEmptySuitesForm() throws Exception {
        this.getContentFromSimplePropertiesPage();
        PropertiesResponderTest.assertSubString((String)"Suites", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<input type=\"text\" id=\"Suites\" title=\"Separate tags by a comma\" name=\"Suites\" value=\"\"", (String)this.content);
    }

    public void testSuitesDisplayed() throws Exception {
        WikiPage page = this.getContentFromSimplePropertiesPage();
        PageData data = page.getData();
        data.setAttribute("Suites", "smoke");
        page.commit(data);
        this.getPropertiesContentFromPage(page);
        PropertiesResponderTest.assertSubString((String)"Suites", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<input type=\"text\" id=\"Suites\" title=\"Separate tags by a comma\" name=\"Suites\" value=\"smoke\"", (String)this.content);
        PropertiesResponderTest.assertSubString((String)"<h5> smoke</h5>", (String)this.content);
    }
}

