/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.InputStreamResponse;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.files.DirectoryResponder;
import fitnesse.responders.files.FileResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.testutil.SampleFileUtility;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.RegexTestCase;

public class FileResponderTest {
    MockRequest request;
    private final String HTTP_DATE_REGEXP = "[SMTWF][a-z]{2}\\,\\s[0-9]{2}\\s[JFMASOND][a-z]{2}\\s[0-9]{4}\\s[0-9]{2}\\:[0-9]{2}\\:[0-9]{2}\\sGMT";
    private Response response;
    private FitNesseContext context;
    private FileResponder responder;
    private Locale saveLocale;

    @Before
    public void setUp() throws Exception {
        this.request = new MockRequest();
        this.context = FitNesseUtil.makeTestContext(null);
        SampleFileUtility.makeSampleFiles();
        this.response = null;
        this.saveLocale = Locale.getDefault();
        FitNesseUtil.makeTestContext();
    }

    @After
    public void tearDown() throws Exception {
        if (this.response != null) {
            this.response.sendTo((ResponseSender)new MockResponseSender());
        }
        SampleFileUtility.deleteSampleFiles();
        Locale.setDefault(this.saveLocale);
    }

    @Test
    public void testFileContent() throws Exception {
        this.request.setResource("files/testFile1");
        this.responder = (FileResponder)FileResponder.makeResponder((Request)this.request, (String)"TestDir");
        this.response = this.responder.makeResponse(this.context, (Request)this.request);
        RegexTestCase.assertEquals(InputStreamResponse.class, this.response.getClass());
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(this.response);
        RegexTestCase.assertSubString((String)"file1 content", (String)sender.sentData());
    }

    @Test
    public void testClasspathResourceContent() throws Exception {
        this.request.setResource("files/fitnesse/testresource.txt");
        this.responder = (FileResponder)FileResponder.makeResponder((Request)this.request, (String)"TestDir");
        this.response = this.responder.makeResponse(this.context, (Request)this.request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(this.response);
        RegexTestCase.assertSubString((String)"test resource content", (String)sender.sentData());
    }

    @Test
    public void testSpacesInFileName() throws Exception {
        this.request.setResource("files/test%20File%20With%20Spaces%20In%20Name");
        this.responder = (FileResponder)FileResponder.makeResponder((Request)this.request, (String)"TestDir");
        Assert.assertEquals((Object)(this.context.rootDirectoryName + File.separator + "files" + File.separator + "test File With Spaces In Name"), (Object)this.responder.requestedFile.getPath());
        this.request.setResource("files/file4%20with%20spaces%32.txt");
        this.responder = (FileResponder)FileResponder.makeResponder((Request)this.request, (String)"TestDir");
        Assert.assertEquals((Object)"files/file4 with spaces2.txt", (Object)this.responder.resource);
    }

    @Test
    public void testLastModifiedHeader() throws Exception {
        Locale.setDefault(Locale.US);
        this.request.setResource("files/testFile1");
        this.responder = (FileResponder)FileResponder.makeResponder((Request)this.request, (String)"TestDir");
        this.response = this.responder.makeResponse(this.context, (Request)this.request);
        String lastModifiedHeader = this.response.getHeader("Last-Modified");
        RegexTestCase.assertMatches((String)"[SMTWF][a-z]{2}\\,\\s[0-9]{2}\\s[JFMASOND][a-z]{2}\\s[0-9]{4}\\s[0-9]{2}\\:[0-9]{2}\\:[0-9]{2}\\sGMT", (String)lastModifiedHeader);
    }

    @Test
    public void testLastModifiedHeaderForClasspathResources() throws Exception {
        Locale.setDefault(Locale.US);
        this.request.setResource("files/fitnesse/css/fitnesse.css");
        this.responder = (FileResponder)FileResponder.makeResponder((Request)this.request, (String)"TestDir");
        this.response = this.responder.makeResponse(this.context, (Request)this.request);
        String lastModifiedHeader = this.response.getHeader("Last-Modified");
        RegexTestCase.assertMatches((String)"[SMTWF][a-z]{2}\\,\\s[0-9]{2}\\s[JFMASOND][a-z]{2}\\s[0-9]{4}\\s[0-9]{2}\\:[0-9]{2}\\:[0-9]{2}\\sGMT", (String)lastModifiedHeader);
    }

    private void test304IfNotModified(String resource) throws IOException {
        Locale.setDefault(Locale.US);
        GregorianCalendar now = new GregorianCalendar();
        ((Calendar)now).add(5, -1);
        String yesterday = SimpleResponse.makeStandardHttpDateFormat().format(now.getTime());
        ((Calendar)now).add(5, 2);
        String tomorrow = SimpleResponse.makeStandardHttpDateFormat().format(now.getTime());
        this.request.setResource(resource);
        this.request.addHeader("If-Modified-Since", (Object)yesterday);
        this.responder = (FileResponder)FileResponder.makeResponder((Request)this.request, (String)"TestDir");
        this.response = this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)200L, (long)this.response.getStatus());
        this.request.setResource(resource);
        this.request.addHeader("If-Modified-Since", (Object)tomorrow);
        this.responder = (FileResponder)FileResponder.makeResponder((Request)this.request, (String)"TestDir");
        SimpleResponse notModifiedResponse = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)304L, (long)notModifiedResponse.getStatus());
        Assert.assertEquals((Object)"", (Object)notModifiedResponse.getContent());
        RegexTestCase.assertMatches((String)"[SMTWF][a-z]{2}\\,\\s[0-9]{2}\\s[JFMASOND][a-z]{2}\\s[0-9]{4}\\s[0-9]{2}\\:[0-9]{2}\\:[0-9]{2}\\sGMT", (String)notModifiedResponse.getHeader("Date"));
        Assert.assertNotNull((Object)notModifiedResponse.getHeader("Cache-Control"));
    }

    @Test
    public void test304IfNotModifiedForFiles() throws IOException {
        this.test304IfNotModified("files/testFile1");
    }

    @Test
    public void test304IfNotModifiedForClasspathResources() throws IOException {
        this.test304IfNotModified("files/fitnesse/css/fitnesse.css");
    }

    @Test
    public void testRecoverFromUnparseableDateInIfNotModifiedHeader() throws Exception {
        this.request.setResource("files/testFile1");
        this.request.addHeader("If-Modified-Since", (Object)"Unparseable Date");
        this.responder = (FileResponder)FileResponder.makeResponder((Request)this.request, (String)"TestDir");
        this.response = this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)200L, (long)this.response.getStatus());
    }

    @Test
    public void testNotFoundFile() throws Exception {
        this.request.setResource("files/something/that/aint/there");
        Responder notFoundResponder = FileResponder.makeResponder((Request)this.request, (String)"TestDir");
        SimpleResponse response = (SimpleResponse)notFoundResponder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        RegexTestCase.assertHasRegexp((String)"files/something/that/aint/there", (String)response.getContent());
    }

    @Test
    public void testCssMimeType() throws Exception {
        SampleFileUtility.addFile((String)"/files/fitnesse.css", (String)"body{color: red;}");
        this.request.setResource("files/fitnesse.css");
        this.responder = (FileResponder)FileResponder.makeResponder((Request)this.request, (String)"TestDir");
        this.response = this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertEquals((Object)"text/css", (Object)this.response.getContentType());
    }

    @Test
    public void testNavigationBackToFrontPage() throws Exception {
        this.request.setResource("files/");
        DirectoryResponder responder = (DirectoryResponder)FileResponder.makeResponder((Request)this.request, (String)"TestDir");
        this.response = responder.makeResponse(this.context, (Request)this.request);
        this.response = responder.makeResponse(this.context, (Request)this.request);
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(this.response);
        RegexTestCase.assertSubString((String)"<a href=\"/FrontPage\" id=\"art_niche\"", (String)sender.sentData());
    }
}

