/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.Responder;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ResponderTestCase;
import fitnesse.responders.refactoring.MovePageResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class MovePageResponderTest
extends ResponderTestCase {
    private WikiPage pageOne;
    private WikiPage pageA;
    private WikiPage pageTwo;
    private MovePageResponder moveResponder;

    protected Responder responderInstance() {
        return new MovePageResponder();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.moveResponder = (MovePageResponder)this.responder;
        this.pageOne = this.crawler.addPage(this.root, PathParser.parse((String)"PageOne"), "^PageA");
        this.pageA = this.crawler.addPage(this.pageOne, PathParser.parse((String)"PageA"), "content");
        this.pageTwo = this.crawler.addPage(this.root, PathParser.parse((String)"PageTwo"));
    }

    public void testIsChildOf() throws Exception {
        WikiPage parent = this.crawler.addPage(this.root, PathParser.parse((String)"TheParent"));
        WikiPage child = this.crawler.addPage(parent, PathParser.parse((String)"TheChild"));
        WikiPage grandChild = this.crawler.addPage(child, PathParser.parse((String)"TheGrandChild"));
        this.assertIsAncestor(parent, child);
        this.assertIsAncestor(parent, grandChild);
        this.assertIsAncestor(parent, parent);
        this.assertIsNotAncestor(child, parent);
        this.assertIsNotAncestor(grandChild, parent);
    }

    private void assertIsNotAncestor(WikiPage supposedAncestor, WikiPage supposedDescendent) {
        MovePageResponderTest.assertFalse((boolean)this.isAncestor(supposedAncestor, supposedDescendent));
    }

    private void assertIsAncestor(WikiPage expectedAncestor, WikiPage expectedDescendent) {
        MovePageResponderTest.assertTrue((boolean)this.isAncestor(expectedAncestor, expectedDescendent));
    }

    private boolean isAncestor(WikiPage ancestor, WikiPage descendent) {
        return this.moveResponder.pageIsAncestorOfNewParent(this.crawler.getFullPath(ancestor), this.crawler.getFullPath(descendent));
    }

    public void testMovePage() throws Exception {
        PageData data = this.pageA.getData();
        data.setAttribute("someAttribute", "someValue");
        this.pageA.commit(data);
        String sourcePage = "PageOne.PageA";
        String destinationPage = "PageTwo.PageA";
        String destinationParent = "PageTwo";
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageOne.PageA")));
        MovePageResponderTest.assertFalse((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageTwo.PageA")));
        this.movePage("PageOne.PageA", "PageTwo", true);
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageTwo.PageA")));
        MovePageResponderTest.assertFalse((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageOne.PageA")));
        WikiPagePath destinationPath = PathParser.parse((String)"PageTwo.PageA");
        WikiPage movedPage = this.crawler.getPage(this.root, destinationPath);
        data = movedPage.getData();
        MovePageResponderTest.assertEquals((String)"content", (String)data.getContent());
        MovePageResponderTest.assertEquals((String)"someValue", (String)data.getAttribute("someAttribute"));
    }

    private SimpleResponse movePage(String pageToMove, String newParent, boolean refactorReferences) throws Exception {
        this.request.addInput("newLocation", (Object)newParent);
        this.request.setResource(pageToMove);
        if (refactorReferences) {
            this.request.addInput("refactorReferences", (Object)"on");
        }
        return (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
    }

    private SimpleResponse movePage(WikiPagePath pageToMove, WikiPagePath newParent, boolean refactorReferences) throws Exception {
        return this.movePage(PathParser.render((WikiPagePath)pageToMove), PathParser.render((WikiPagePath)newParent), refactorReferences);
    }

    public void testReferencesChanged() throws Exception {
        this.movePage("PageOne.PageA", "PageTwo", true);
        this.pageOne = this.root.getChildPage("PageOne");
        MovePageResponderTest.assertEquals((String)".PageTwo.PageA", (String)this.pageOne.getData().getContent());
    }

    public void testReferenceToSubPageChanged() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"ReferingPage"), "PageOne.PageA");
        this.movePage("PageOne", "PageTwo", true);
        WikiPage referingPage = this.root.getChildPage("ReferingPage");
        MovePageResponderTest.assertEquals((String)".PageTwo.PageOne.PageA", (String)referingPage.getData().getContent());
    }

    public void testReferenceToSubPageNotChangedWhenDisabled() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"ReferingPage"), "PageOne.PageA");
        this.movePage("PageOne", "PageTwo", false);
        WikiPage referingPage = this.root.getChildPage("ReferingPage");
        MovePageResponderTest.assertEquals((String)"PageOne.PageA", (String)referingPage.getData().getContent());
    }

    public void testCantMoveToSelf() throws Exception {
        this.pageA.getData().setAttribute("someAttribute", "someValue");
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageOne.PageA")));
        SimpleResponse response = this.movePage("PageOne.PageA", "PageOne", true);
        MovePageResponderTest.assertSubString((String)"Cannot move", (String)response.getContent());
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageOne.PageA")));
    }

    public void testCantReplaceExistingPage() throws Exception {
        this.crawler.addPage(this.pageTwo, PathParser.parse((String)"PageA"), "someContent");
        this.pageA.getData().setAttribute("someAttribute", "someValue");
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageTwo.PageA")));
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageOne.PageA")));
        SimpleResponse response = this.movePage("PageOne.PageA", "PageTwo", true);
        MovePageResponderTest.assertSubString((String)"Cannot move", (String)response.getContent());
        MovePageResponderTest.assertEquals((String)"someContent", (String)this.pageTwo.getChildPage("PageA").getData().getContent());
        MovePageResponderTest.assertEquals((String)"content", (String)this.pageA.getData().getContent());
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageTwo.PageA")));
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageOne.PageA")));
    }

    public void testChildrenGetMovedIfParentMoves() throws Exception {
        String sourceChildOne = "PageOne.PageA.ChildOne";
        String sourceChildTwo = "PageOne.PageA.ChildTwo";
        String sourceGrandChild = "PageOne.PageA.ChildTwo.ChildTwoDotOne";
        String parentToMove = "PageOne.PageA";
        String destinationParent = "PageTwo";
        String destinationPage = "PageTwo.PageA";
        String destinationChildOne = "PageTwo.PageA.ChildOne";
        String destinationChildTwo = "PageTwo.PageA.ChildTwo";
        String destinationGrandChild = "PageTwo.PageA.ChildTwo.ChildTwoDotOne";
        WikiPagePath sourceChildOnePath = PathParser.parse((String)"PageOne.PageA.ChildOne");
        WikiPagePath sourceChildTwoPath = PathParser.parse((String)"PageOne.PageA.ChildTwo");
        WikiPagePath sourceGrandChildPath = PathParser.parse((String)"PageOne.PageA.ChildTwo.ChildTwoDotOne");
        WikiPagePath destinationPagePath = PathParser.parse((String)"PageTwo.PageA");
        WikiPagePath destinationChildOnePath = PathParser.parse((String)"PageTwo.PageA.ChildOne");
        WikiPagePath destinationChildTwoPath = PathParser.parse((String)"PageTwo.PageA.ChildTwo");
        WikiPagePath destinationGrandChildPath = PathParser.parse((String)"PageTwo.PageA.ChildTwo.ChildTwoDotOne");
        this.crawler.addPage(this.root, sourceChildOnePath, "child1Content");
        this.crawler.addPage(this.root, sourceChildTwoPath, "child2Content");
        this.crawler.addPage(this.root, sourceGrandChildPath);
        this.movePage("PageOne.PageA", "PageTwo", true);
        WikiPage movedPage = this.crawler.getPage(this.root, destinationPagePath);
        MovePageResponderTest.assertFalse((boolean)this.crawler.pageExists(this.root, sourceChildOnePath));
        MovePageResponderTest.assertFalse((boolean)this.crawler.pageExists(this.root, sourceChildTwoPath));
        List children = movedPage.getChildren();
        MovePageResponderTest.assertEquals((int)2, (int)children.size());
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, destinationChildOnePath));
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, destinationChildTwoPath));
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, destinationGrandChildPath));
    }

    public void testCantMovePageBelowChild() throws Exception {
        SimpleResponse response = this.movePage("PageOne", "PageOne.PageA", true);
        MovePageResponderTest.assertSubString((String)"Cannot move", (String)response.getContent());
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageOne.PageA")));
    }

    public void testMoveToRoot() throws Exception {
        WikiPagePath originalPath = PathParser.parse((String)"PageOne.PageA");
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, originalPath));
        this.movePage(originalPath, PathParser.parse((String)""), true);
        WikiPage movedPage = this.root.getChildPage(this.pageA.getName());
        MovePageResponderTest.assertFalse((boolean)this.crawler.pageExists(this.root, originalPath));
        MovePageResponderTest.assertEquals((String)"content", (String)movedPage.getData().getContent());
        MovePageResponderTest.assertEquals((Object)PathParser.parse((String)"PageA"), (Object)this.crawler.getFullPath(movedPage));
        this.pageOne = this.root.getChildPage(this.pageOne.getName());
        MovePageResponderTest.assertEquals((String)".PageA", (String)this.pageOne.getData().getContent());
    }

    public void testMoveFromRoot() throws Exception {
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageOne")));
        this.movePage("PageOne", "PageTwo", true);
        WikiPage movedPage = this.pageTwo.getChildPage("PageOne");
        MovePageResponderTest.assertFalse((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageOne")));
        MovePageResponderTest.assertEquals((String)".PageTwo.PageOne.PageA", (String)movedPage.getData().getContent());
        MovePageResponderTest.assertEquals((String)"PageTwo.PageOne", (String)PathParser.render((WikiPagePath)this.crawler.getFullPath(movedPage)));
    }

    public void testRedirection() throws Exception {
        String url = this.moveResponder.createRedirectionUrl(this.pageOne, this.pageA.getName());
        MovePageResponderTest.assertEquals((String)"PageOne.PageA", (String)url);
        url = this.moveResponder.createRedirectionUrl(this.root, this.pageA.getName());
        MovePageResponderTest.assertEquals((String)"PageA", (String)url);
    }

    public void testBadMoveLocationName() throws Exception {
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageOne.PageA")));
        SimpleResponse response = this.movePage("PageOne.PageA", "NoSuchPage", true);
        MovePageResponderTest.assertSubString((String)"Cannot move", (String)response.getContent());
        MovePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"PageOne.PageA")));
    }

    public void testMovePageIntoItselfIsNotAllowed() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"));
        SimpleResponse response = this.movePage("TestPage", "TestPage", true);
        MovePageResponderTest.assertFalse((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"TestPage.TestPage")));
        MovePageResponderTest.assertEquals((int)400, (int)response.getStatus());
        MovePageResponderTest.assertSubString((String)"Cannot move", (String)response.getContent());
    }
}

