/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.Responder;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.ResponderTestCase;
import fitnesse.responders.refactoring.RenamePageResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

/*
 * Exception performing whole class analysis ignored.
 */
public class RenamePageResponderTest
extends ResponderTestCase {
    private WikiPagePath pageOnePath;
    private WikiPagePath pageTwoPath;
    private String pageOneName;
    private String pageTwoName;

    protected Responder responderInstance() {
        return new RenamePageResponder();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.pageOneName = "PageOne";
        this.pageTwoName = "PageTwo";
        this.pageOnePath = PathParser.parse((String)this.pageOneName);
        this.pageTwoPath = PathParser.parse((String)this.pageTwoName);
    }

    public void testInvalidName() throws Exception {
        String invalidName = "FirstName.SecondName";
        String pageName = "MyPage";
        this.crawler.addPage(this.root, PathParser.parse((String)pageName), "content");
        Response response = this.doRename(pageName, invalidName, true);
        RenamePageResponderTest.assertHasRegexp((String)"Cannot rename", (String)this.getResponseContent(response));
    }

    public void testDontRenameFrontPage() throws Exception {
        String frontPageName = "FrontPage";
        this.crawler.addPage(this.root, PathParser.parse((String)frontPageName), "Content");
        Response response = this.doRename(frontPageName, "ReNamed", true);
        RenamePageResponderTest.assertNotNull((Object)response);
        RenamePageResponderTest.assertSubString((String)"Cannot rename", (String)this.getResponseContent(response));
    }

    public void testPageRedirection() throws Exception {
        WikiPage pageOne = this.crawler.addPage(this.root, PathParser.parse((String)"OneOne"), "Content");
        this.crawler.addPage(pageOne, PathParser.parse((String)"TwoOne"));
        Response response = this.doRename("OneOne.TwoOne", "ReName", true);
        RenamePageResponderTest.assertNotNull((Object)response);
        RenamePageResponderTest.assertEquals((int)303, (int)response.getStatus());
        RenamePageResponderTest.assertEquals((String)"OneOne.ReName", (String)response.getHeader("Location"));
    }

    public void testPageWasRenamed() throws Exception {
        String originalName = "OneOne";
        WikiPagePath originalPath = PathParser.parse((String)originalName);
        String renamedName = "WonWon";
        WikiPagePath renamedPath = PathParser.parse((String)renamedName);
        this.crawler.addPage(this.root, originalPath, "Content");
        RenamePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, originalPath));
        RenamePageResponderTest.assertFalse((boolean)this.crawler.pageExists(this.root, renamedPath));
        this.doRename(originalName, renamedName, true);
        RenamePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, renamedPath));
        RenamePageResponderTest.assertFalse((boolean)this.crawler.pageExists(this.root, originalPath));
    }

    public void testReferencesChanged() throws Exception {
        this.crawler.addPage(this.root, this.pageOnePath, "Line one\nPageTwo\nLine three");
        this.crawler.addPage(this.root, this.pageTwoPath, "Page two content");
        this.doRename(this.pageTwoName, "PageThree", true);
        WikiPage pageOne = this.root.getChildPage(this.pageOneName);
        RenamePageResponderTest.assertEquals((String)"Line one\nPageThree\nLine three", (String)pageOne.getData().getContent());
    }

    public void testBackSearchReferencesChanged() throws Exception {
        WikiPage topPage = this.crawler.addPage(this.root, PathParser.parse((String)"TopPage"), "");
        WikiPage pageOne = this.crawler.addPage(topPage, this.pageOnePath, "Line one\n<TopPage.PageTwo\nLine three");
        this.crawler.addPage(topPage, this.pageTwoPath, "Page two content");
        this.doRename("TopPage.PageTwo", "PageThree", true);
        RenamePageResponderTest.assertEquals((String)"Line one\n<TopPage.PageThree\nLine three", (String)pageOne.getData().getContent());
    }

    public void testReferencesNotChangedWhenDisabled() throws Exception {
        this.crawler.addPage(this.root, this.pageOnePath, "Line one\nPageTwo\nLine three");
        this.crawler.addPage(this.root, this.pageTwoPath, "Page two content");
        this.doRename(this.pageTwoName, "PageThree", false);
        WikiPage pageOne = this.root.getChildPage(this.pageOneName);
        RenamePageResponderTest.assertEquals((String)"Line one\nPageTwo\nLine three", (String)pageOne.getData().getContent());
    }

    public void testDontRenameToExistingPage() throws Exception {
        this.crawler.addPage(this.root, this.pageOnePath, "Page one content");
        this.crawler.addPage(this.root, this.pageTwoPath, "Page two content");
        Response response = this.doRename(this.pageOneName, this.pageTwoName, true);
        RenamePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, this.pageOnePath));
        RenamePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, this.pageTwoPath));
        RenamePageResponderTest.assertEquals((String)"Page two content", (String)this.root.getChildPage(this.pageTwoName).getData().getContent());
        RenamePageResponderTest.assertSubString((String)"Cannot rename", (String)this.getResponseContent(response));
    }

    public void testChildPagesStayIntactWhenParentIsRenamed() throws Exception {
        this.crawler.addPage(this.root, this.pageOnePath, "page one");
        this.crawler.addPage(this.root, PathParser.parse((String)"PageOne.ChildPage"), "child page");
        this.crawler.addPage(this.root, PathParser.parse((String)"PageOne.ChildPage.GrandChild"), "grand child");
        this.doRename(this.pageOneName, this.pageTwoName, true);
        WikiPagePath path = PathParser.parse((String)"PageTwo.ChildPage");
        RenamePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, path));
        WikiPage page = this.crawler.getPage(this.root, path);
        RenamePageResponderTest.assertNotNull((Object)page);
        RenamePageResponderTest.assertEquals((String)"child page", (String)page.getData().getContent());
        WikiPagePath grandChildPath = PathParser.parse((String)"PageTwo.ChildPage.GrandChild");
        RenamePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, grandChildPath));
        page = this.crawler.getPage(this.root, grandChildPath);
        RenamePageResponderTest.assertNotNull((Object)page);
        RenamePageResponderTest.assertEquals((String)"grand child", (String)page.getData().getContent());
    }

    private String getResponseContent(Response response) throws Exception {
        MockResponseSender sender = new MockResponseSender();
        sender.doSending(response);
        return sender.sentData();
    }

    private Response doRename(String fromName, String toName, boolean renameReferences) throws Exception {
        this.request.setResource(fromName);
        this.request.addInput("newName", (Object)toName);
        if (renameReferences) {
            this.request.addInput("refactorReferences", (Object)"on");
        }
        return this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
    }
}

