/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.components.ContentReplacingSearchObserver;
import fitnesse.components.PageFinder;
import fitnesse.components.RegularExpressionWikiPageFinder;
import fitnesse.components.TraversalListener;
import fitnesse.responders.search.ResultResponder;
import fitnesse.wiki.WikiPage;

public class SearchReplaceResponder
extends ResultResponder
implements TraversalListener<WikiPage> {
    private PageFinder finder;
    private TraversalListener<? super WikiPage> contentReplaceObserver;
    private TraversalListener<? super WikiPage> webOutputObserver;

    protected String getPageFooterInfo(int hits) {
        return String.format("Replaced %d matches for your search.", hits);
    }

    protected String getTitle() {
        return String.format("Replacing matching content \"%s\" with content \"%s\"", this.getSearchString(), this.getReplacementString());
    }

    private String getReplacementString() {
        return (String)this.request.getInput("replacementString");
    }

    private String getSearchString() {
        return (String)this.request.getInput("searchString");
    }

    public void process(WikiPage page) {
        this.contentReplaceObserver.process((Object)page);
        this.webOutputObserver.process((Object)page);
    }

    public void traverse(TraversalListener<Object> observer) {
        this.webOutputObserver = observer;
        String searchString = this.getSearchString();
        String replacementString = this.getReplacementString();
        this.contentReplaceObserver = new ContentReplacingSearchObserver(searchString, replacementString);
        this.finder = new RegularExpressionWikiPageFinder(searchString, (TraversalListener)this);
        this.finder.search(this.page);
    }
}

