/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.JavaFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.xml.sax.InputSource;

public class JavaFormatterFolderResultsRepositoryTest {
    private static final String TEST_NAME = "testName";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private JavaFormatter.FolderResultsRepository repository;

    @Before
    public void prepareFolder() throws Exception {
        String tempDir = this.temporaryFolder.getRoot().getAbsolutePath();
        this.repository = new JavaFormatter.FolderResultsRepository(tempDir);
    }

    @Test
    public void usesTestNameAsHeadingWithinValidHtmlStructure() throws Exception {
        this.repository.open(TEST_NAME);
        this.repository.close();
        String heading = this.evaluateXPathAgainstOutputHtml("/html/body/header/h2/text()");
        Assert.assertEquals((Object)TEST_NAME, (Object)heading);
    }

    @Test
    public void usesUtf8Encoding() throws Exception {
        this.repository.open(TEST_NAME);
        this.repository.write("someContent\u263a");
        this.repository.close();
        String outputHtml = this.readOutputHtml("utf8");
        Assert.assertTrue((boolean)outputHtml.contains("someContent\u263a"));
        Assert.assertTrue((boolean)outputHtml.contains("<meta http-equiv='Content-Type' content='text/html;charset=utf-8'/>"));
    }

    private String evaluateXPathAgainstOutputHtml(String expression) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
        InputSource inputSource = new InputSource(this.getHtmlOutputStream());
        return xpath.evaluate(expression, inputSource);
    }

    private String readOutputHtml(String encoding) throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getHtmlOutputStream(), encoding);
        StringBuilder result = new StringBuilder();
        char[] buffer = new char[1000];
        while (reader.read(buffer) > 0) {
            result.append(buffer);
        }
        return result.toString();
    }

    private InputStream getHtmlOutputStream() throws FileNotFoundException {
        File outputHtml = new File(this.temporaryFolder.getRoot(), "testName.html");
        return new FileInputStream(outputHtml);
    }
}

