/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.JavaFormatter;
import fitnesse.responders.run.ResultsListener;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import util.TimeMeasurement;

public class JavaFormatterTest {
    private final String nestedPageName = "ParentTest.ChildTest";
    private final String suiteName = "MySuite";
    JavaFormatter jf;
    JavaFormatter.ResultsRepository mockResultsRepository;
    ResultsListener listener;

    @Before
    public void prepare() {
        this.jf = new JavaFormatter("MySuite");
        this.mockResultsRepository = (JavaFormatter.ResultsRepository)Mockito.mock(JavaFormatter.ResultsRepository.class);
        this.jf.setResultsRepository(this.mockResultsRepository);
        this.listener = (ResultsListener)Mockito.mock(ResultsListener.class);
    }

    @Test
    public void getFullPath_WalksUpWikiPageParentsAndBuildsFullPathToPage() throws Exception {
        TestPage wp = this.buildNestedTestPage();
        Assert.assertEquals((Object)"ParentTest.ChildTest", (Object)this.jf.getFullPath(wp.getSourcePage()));
    }

    private TestPage buildNestedTestPage() throws Exception {
        WikiPageDummy wp = new WikiPageDummy("ChildTest", null);
        WikiPageDummy parent = new WikiPageDummy("ParentTest", null);
        wp.setParent((WikiPage)parent);
        parent.setParent((WikiPage)new WikiPageDummy("root"));
        return new TestPage((WikiPage)wp);
    }

    @Test
    public void newTestStarted_SwitchesResultRepositoryToCurrentTest() throws Exception {
        TestPage wp = this.buildNestedTestPage();
        TimeMeasurement timeMeasurement = new TimeMeasurement();
        this.jf.newTestStarted(wp, timeMeasurement.start());
        ((JavaFormatter.ResultsRepository)Mockito.verify((Object)this.mockResultsRepository)).open("ParentTest.ChildTest");
    }

    @Test
    public void testComplete_closesResultRepositoryAndAddsToTotalTestSummary() throws Exception {
        this.jf.setTotalSummary(new TestSummary(1, 2, 3, 4));
        TimeMeasurement timeMeasurement = new TimeMeasurement().start();
        this.jf.testComplete(this.buildNestedTestPage(), new TestSummary(5, 6, 7, 8), timeMeasurement.stop());
        Assert.assertEquals((Object)new TestSummary(6, 8, 10, 12), (Object)this.jf.getTotalSummary());
        ((JavaFormatter.ResultsRepository)Mockito.verify((Object)this.mockResultsRepository)).close();
    }

    @Test
    public void writeSummary_WritesSummaryOfTestExecutions() throws Exception {
        TimeMeasurement timeMeasurement = new TimeMeasurement().start();
        this.jf.testComplete(this.buildNestedTestPage(), new TestSummary(5, 6, 7, 8), timeMeasurement.stop());
        WikiPageDummy secondPage = new WikiPageDummy("SecondPage", null);
        secondPage.setParent((WikiPage)new WikiPageDummy("root", null));
        this.jf.testComplete(new TestPage((WikiPage)secondPage), new TestSummary(11, 12, 13, 14), timeMeasurement.stop());
        this.jf.writeSummary("SummaryPageName");
        String expectedOutput = new StringBuffer().append("<table><tr><td>Name</td><td>Right</td><td>Wrong</td><td>Exceptions</td></tr>").append(new JavaFormatter.TestResultsSummaryTableRow("ParentTest.ChildTest", new TestSummary(5, 6, 7, 8)).toString()).append(new JavaFormatter.TestResultsSummaryTableRow("SecondPage", new TestSummary(11, 12, 13, 14)).toString()).append("</table>").toString();
        ((JavaFormatter.ResultsRepository)Mockito.verify((Object)this.mockResultsRepository)).open("SummaryPageName");
        ((JavaFormatter.ResultsRepository)Mockito.verify((Object)this.mockResultsRepository, (VerificationMode)Mockito.times((int)1))).write(expectedOutput);
    }

    @Test
    public void testComplete_clones_TestSummary_Objects() throws Exception {
        WikiPageDummy secondPage = new WikiPageDummy("SecondPage", null);
        secondPage.setParent((WikiPage)new WikiPageDummy("root", null));
        TestSummary ts = new TestSummary(5, 6, 7, 8);
        TimeMeasurement timeMeasurement = new TimeMeasurement().start();
        this.jf.testComplete(this.buildNestedTestPage(), ts, timeMeasurement.stop());
        ts.right = 11;
        ts.wrong = 12;
        ts.ignores = 13;
        ts.exceptions = 14;
        this.jf.testComplete(new TestPage((WikiPage)secondPage), ts, timeMeasurement.stop());
        Assert.assertEquals((Object)new TestSummary(5, 6, 7, 8), (Object)this.jf.getTestSummary("ParentTest.ChildTest"));
    }

    @Test
    public void summaryRowFormatsTestOutputRows() {
        Assert.assertEquals((String)"pass, no errors or exceptions", (Object)"<tr class=\"pass\"><td><a href=\"TestName.html\">TestName</a></td><td>5</td><td>0</td><td>0</td></tr>", (Object)new JavaFormatter.TestResultsSummaryTableRow("TestName", new TestSummary(5, 0, 0, 0)).toString());
        Assert.assertEquals((String)"red, 1 error ", (Object)"<tr class=\"fail\"><td><a href=\"TestName.html\">TestName</a></td><td>5</td><td>1</td><td>0</td></tr>", (Object)new JavaFormatter.TestResultsSummaryTableRow("TestName", new TestSummary(5, 1, 0, 0)).toString());
        Assert.assertEquals((String)"error,exceptions", (Object)"<tr class=\"error\"><td><a href=\"TestName.html\">TestName</a></td><td>5</td><td>6</td><td>7</td></tr>", (Object)new JavaFormatter.TestResultsSummaryTableRow("TestName", new TestSummary(5, 6, 0, 7)).toString());
    }

    @Test
    public void testOutputChunk_forwardsWriteToResultRepository() throws Exception {
        this.jf.testOutputChunk("Hey there!");
        ((JavaFormatter.ResultsRepository)Mockito.verify((Object)this.mockResultsRepository)).write("Hey there!");
    }

    @Test
    public void getInstance_ReturnsTheSameObjectForTheSameTest() {
        Assert.assertSame((Object)JavaFormatter.getInstance((String)"TestOne"), (Object)JavaFormatter.getInstance((String)"TestOne"));
        Assert.assertNotSame((Object)JavaFormatter.getInstance((String)"TestOne"), (Object)JavaFormatter.getInstance((String)"TestTwo"));
    }

    @Test
    public void allTestingComplete_writesSummaryIfMainPageWasntExecuted() throws Exception {
        TimeMeasurement timeMeasurement = new TimeMeasurement().start();
        this.jf.testComplete(this.buildNestedTestPage(), new TestSummary(5, 6, 7, 8), timeMeasurement.stop());
        this.jf.allTestingComplete(timeMeasurement);
        ((JavaFormatter.ResultsRepository)Mockito.verify((Object)this.mockResultsRepository)).open("MySuite");
    }

    @Test
    public void allTestingComplete_doesntWriteSummaryIfMainPageWasExecuted() throws Exception {
        this.jf = JavaFormatter.getInstance((String)"ParentTest.ChildTest");
        this.jf.setResultsRepository(this.mockResultsRepository);
        TimeMeasurement timeMeasurement = new TimeMeasurement().start();
        this.jf.testComplete(this.buildNestedTestPage(), new TestSummary(5, 6, 7, 8), timeMeasurement.stop());
        this.jf.allTestingComplete(timeMeasurement);
        ((JavaFormatter.ResultsRepository)Mockito.verify((Object)this.mockResultsRepository, (VerificationMode)Mockito.times((int)0))).open("ParentTest.ChildTest");
    }

    @Test
    public void ifListenerIsSet_newTestStartedFiresTestStarted() throws Exception {
        this.jf.setListener(this.listener);
        TestPage page = this.buildNestedTestPage();
        TimeMeasurement timeMeasurement = new TimeMeasurement();
        this.jf.newTestStarted(page, timeMeasurement.start());
        ((ResultsListener)Mockito.verify((Object)this.listener)).newTestStarted(page, timeMeasurement);
    }

    @Test
    public void ifListenerIsSet_TestCompleteFiresTestComplete() throws Exception {
        this.jf.setListener(this.listener);
        TestPage page = this.buildNestedTestPage();
        TimeMeasurement timeMeasurement = new TimeMeasurement().start();
        this.jf.testComplete(page, new TestSummary(1, 2, 3, 4), timeMeasurement.stop());
        ((ResultsListener)Mockito.verify((Object)this.listener)).testComplete(page, new TestSummary(1, 2, 3, 4), timeMeasurement);
    }

    @Test
    public void ifListenerIsSet_AllTestingCompleteFiresAllTestingComplete() throws Exception {
        this.jf.setListener(this.listener);
        TimeMeasurement totalTimeMeasurement = new TimeMeasurement().start().stop();
        this.jf.allTestingComplete(totalTimeMeasurement);
        ((ResultsListener)Mockito.verify((Object)this.listener)).allTestingComplete((TimeMeasurement)Mockito.same((Object)totalTimeMeasurement));
    }

    @Test
    public void dropInstance_drops_test_results() {
        JavaFormatter first = JavaFormatter.getInstance((String)"TestName");
        JavaFormatter.dropInstance((String)"TestName");
        JavaFormatter second = JavaFormatter.getInstance((String)"TestName");
        Assert.assertNotSame((Object)first, (Object)second);
    }
}

