/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.components.SocketDealer;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.responders.run.SocketCatchingResponder;
import fitnesse.testsystems.fit.SimpleSocketSeeker;
import fitnesse.testsystems.fit.SocketSeeker;
import fitnesse.testutil.FitNesseUtil;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class SocketCatchingResponderTest
extends RegexTestCase {
    private SocketDealer dealer;
    private SimpleSocketSeeker seeker;
    private MockResponseSender sender;
    private SocketCatchingResponder responder;
    private FitNesseContext context;
    private MockRequest request;

    public void setUp() throws Exception {
        this.seeker = new SimpleSocketSeeker();
        this.sender = new MockResponseSender();
        this.responder = new SocketCatchingResponder();
        this.context = FitNesseUtil.makeTestContext();
        this.dealer = this.context.socketDealer;
        this.request = new MockRequest();
    }

    public void tearDown() throws Exception {
    }

    public void testSuccess() throws Exception {
        int ticket = this.dealer.seekingSocket((SocketSeeker)this.seeker);
        this.request.addInput("ticket", (Object)(ticket + ""));
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        response.sendTo((ResponseSender)this.sender);
        SocketCatchingResponderTest.assertEquals((String)"", (String)this.sender.sentData());
    }

    public void testMissingSeeker() throws Exception {
        this.request.addInput("ticket", (Object)"123");
        Response response = this.responder.makeResponse(this.context, (Request)this.request);
        response.sendTo((ResponseSender)this.sender);
        SocketCatchingResponderTest.assertHasRegexp((String)"There are no clients waiting for a socket with ticketNumber 123", (String)this.sender.sentData());
        SocketCatchingResponderTest.assertTrue((boolean)this.sender.isClosed());
        SocketCatchingResponderTest.assertEquals((int)404, (int)response.getStatus());
    }
}

