/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.testsystems.TestSummary;
import java.util.Date;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SuiteExecutionReportTest {
    private SuiteExecutionReport report1;
    private SuiteExecutionReport report2;

    @Before
    public void setUp() throws Exception {
        this.report1 = new SuiteExecutionReport();
        this.report2 = new SuiteExecutionReport();
    }

    @Test
    public void degeneratesShouldBeEqual() throws Exception {
        Assert.assertEquals((Object)new SuiteExecutionReport(), (Object)new SuiteExecutionReport());
    }

    @Test
    public void shouldNotBeEqualIfDifferentTypes() throws Exception {
        Assert.assertFalse((boolean)new SuiteExecutionReport().equals((Object)new Integer(0)));
    }

    @Test
    public void shouldNotBeEqualWithDifferentRootPaths() throws Exception {
        this.report1.rootPath = "here";
        this.report2.rootPath = "there";
        Assert.assertFalse((boolean)this.report1.equals((Object)this.report2));
    }

    @Test
    public void shouldNotBeEqualIfHaveDifferentReferences() throws Exception {
        this.report1.addPageHistoryReference(new SuiteExecutionReport.PageHistoryReference("pageOne", 1234L, 9L));
        this.report2.addPageHistoryReference(new SuiteExecutionReport.PageHistoryReference("pageTwo", 1234L, 9L));
        Assert.assertFalse((boolean)this.report1.equals((Object)this.report2));
    }

    @Test
    public void shouldBeEqualIfReferencesAreTheSame() throws Exception {
        SuiteExecutionReport.PageHistoryReference r1 = new SuiteExecutionReport.PageHistoryReference("TestPage", 1111L, 8L);
        SuiteExecutionReport.PageHistoryReference r2 = new SuiteExecutionReport.PageHistoryReference("TestPage", 1111L, 8L);
        r1.getTestSummary().right = 3;
        r2.getTestSummary().right = 3;
        this.report1.addPageHistoryReference(r1);
        this.report2.addPageHistoryReference(r2);
        Assert.assertEquals((Object)this.report1, (Object)this.report2);
    }

    @Test
    public void shouldNotBeEqualIfVersionIsDifferent() throws Exception {
        this.report1.version = "x";
        this.report2.version = "y";
        Assert.assertFalse((boolean)this.report1.equals((Object)this.report2));
    }

    @Test
    public void shoudlNotBeEqualIfDateIsDifferent() throws Exception {
        this.report1.date = new Date(1L);
        this.report2.date = new Date(2L);
        Assert.assertFalse((boolean)this.report1.equals((Object)this.report2));
    }

    @Test
    public void shouldNotBeEqualIfFinalCountsAreDifferent() throws Exception {
        this.report1.finalCounts = new TestSummary(1, 2, 3, 4);
        this.report2.finalCounts = new TestSummary(4, 3, 2, 1);
        Assert.assertFalse((boolean)this.report1.equals((Object)this.report2));
    }

    @Test
    public void shouldNotBeEqualIfRunTimesAreDifferent() throws Exception {
        this.report1.addPageHistoryReference(new SuiteExecutionReport.PageHistoryReference("testPage", 1234L, 5L));
        this.report2.addPageHistoryReference(new SuiteExecutionReport.PageHistoryReference("testPage", 1234L, 6L));
        Assert.assertFalse((boolean)this.report1.equals((Object)this.report2));
    }

    @Test
    public void shouldBeEqualWithAllFieldsEqual() throws Exception {
        this.report2.version = "version";
        this.report1.version = "version";
        this.report1.date = this.report2.date = new Date(1L);
        this.report1.finalCounts = this.report2.finalCounts = new TestSummary(4, 5, 6, 7);
        this.report2.rootPath = "rootPath";
        this.report1.rootPath = "rootPath";
        SuiteExecutionReport.PageHistoryReference r1a = new SuiteExecutionReport.PageHistoryReference("testPage", 1234L, 5L);
        SuiteExecutionReport.PageHistoryReference r2a = new SuiteExecutionReport.PageHistoryReference("testPage", 1234L, 5L);
        SuiteExecutionReport.PageHistoryReference r1b = new SuiteExecutionReport.PageHistoryReference("myPage", 7734L, 6L);
        SuiteExecutionReport.PageHistoryReference r2b = new SuiteExecutionReport.PageHistoryReference("myPage", 7734L, 6L);
        r1a.getTestSummary().right = 4;
        r2a.getTestSummary().right = 4;
        this.report1.addPageHistoryReference(r1a);
        this.report1.addPageHistoryReference(r1b);
        this.report2.addPageHistoryReference(r2a);
        this.report2.addPageHistoryReference(r2b);
        Assert.assertEquals((Object)this.report1, (Object)this.report2);
    }

    @Test
    public void shouldHandleMissingRunTimesGraceFully() throws Exception {
        Element element = (Element)Mockito.mock(Element.class);
        NodeList emptyNodeList = (NodeList)Mockito.mock(NodeList.class);
        Mockito.when((Object)element.getElementsByTagName("runTimeInMillis")).thenReturn((Object)emptyNodeList);
        Mockito.when((Object)emptyNodeList.getLength()).thenReturn((Object)0);
        Assert.assertThat((Object)this.report1.getRunTimeInMillisOrZeroIfNotPresent(element), (Matcher)CoreMatchers.is((Object)0L));
        element = (Element)Mockito.mock(Element.class);
        NodeList matchingNodeList = (NodeList)Mockito.mock(NodeList.class);
        Node elementWithText = (Node)Mockito.mock(Element.class);
        NodeList childNodeList = (NodeList)Mockito.mock(NodeList.class);
        Text text = (Text)Mockito.mock(Text.class);
        Mockito.when((Object)element.getElementsByTagName("runTimeInMillis")).thenReturn((Object)matchingNodeList);
        Mockito.when((Object)matchingNodeList.getLength()).thenReturn((Object)1);
        Mockito.when((Object)matchingNodeList.item(0)).thenReturn((Object)elementWithText);
        Mockito.when((Object)elementWithText.getChildNodes()).thenReturn((Object)childNodeList);
        Mockito.when((Object)childNodeList.getLength()).thenReturn((Object)1);
        Mockito.when((Object)childNodeList.item(0)).thenReturn((Object)text);
        Mockito.when((Object)text.getNodeValue()).thenReturn((Object)"255");
        Assert.assertThat((Object)this.report1.getRunTimeInMillisOrZeroIfNotPresent(element), (Matcher)CoreMatchers.is((Object)255L));
    }
}

