/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.responders.run.formatters.SuiteExecutionReportFormatter;
import fitnesse.responders.run.formatters.XmlFormatter;
import fitnesse.testsystems.TestPage;
import fitnesse.wiki.WikiPage;
import java.io.IOException;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import util.TimeMeasurement;

public class SuiteHistoryFormatter
extends SuiteExecutionReportFormatter {
    private Writer writer;
    private XmlFormatter.WriterFactory writerFactory;
    private long suiteTime = 0L;

    public SuiteHistoryFormatter(FitNesseContext context, WikiPage page, Writer writer) throws Exception {
        super(context, page);
        this.writer = writer;
    }

    public void newTestStarted(TestPage test, TimeMeasurement timeMeasurement) {
        if (this.suiteTime == 0L) {
            this.suiteTime = timeMeasurement.startedAt();
        }
        super.newTestStarted(test, timeMeasurement);
    }

    public SuiteHistoryFormatter(FitNesseContext context, WikiPage page, XmlFormatter.WriterFactory source) {
        super(context, page);
        this.writerFactory = source;
    }

    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws IOException {
        super.allTestingComplete(totalTimeMeasurement);
        if (this.writerFactory != null) {
            this.writer = this.writerFactory.getWriter(this.context, this.page, this.getPageCounts(), this.suiteTime);
        }
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("suiteExecutionReport", (Object)this.suiteExecutionReport);
        VelocityEngine velocityEngine = this.context.pageFactory.getVelocityEngine();
        Template template = velocityEngine.getTemplate("suiteHistoryXML.vm");
        template.merge((Context)velocityContext, this.writer);
        this.writer.close();
    }
}

