/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.http.ChunkedResponse;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.testsystems.CompositeExecutionLog;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.IOException;
import java.text.SimpleDateFormat;
import util.TimeMeasurement;

public class TestTextFormatter
extends BaseFormatter {
    private ChunkedResponse response;

    public TestTextFormatter(ChunkedResponse response) {
        this.response = response;
    }

    public void writeHead(String pageType) {
    }

    public void setExecutionLogAndTrackingId(String stopResponderId, CompositeExecutionLog log) {
    }

    public void testSystemStarted(TestSystem testSystem, String testSystemName, String testRunner) {
        this.response.add(String.format("\nStarting Test System: %s using %s.\n", testSystemName, testRunner));
    }

    public void newTestStarted(TestPage page, TimeMeasurement timeMeasurement) {
    }

    private String getPath(WikiPage page) {
        return PathParser.render((WikiPagePath)page.getPageCrawler().getFullPath(page));
    }

    public void testOutputChunk(String output) {
    }

    public void testComplete(TestPage page, TestSummary summary, TimeMeasurement timeMeasurement) throws IOException {
        super.testComplete(page, summary, timeMeasurement);
        String timeString = new SimpleDateFormat("HH:mm:ss").format(timeMeasurement.startedAtDate());
        this.response.add(String.format("%s %s R:%-4d W:%-4d I:%-4d E:%-4d %s\t(%s)\t%.03f seconds\n", this.passFail(summary), timeString, summary.right, summary.wrong, summary.ignores, summary.exceptions, page.getName(), this.getPath(page.getSourcePage()), timeMeasurement.elapsedSeconds()));
    }

    private String passFail(TestSummary summary) {
        if (summary.wrong > 0) {
            return "F";
        }
        if (summary.exceptions > 0) {
            return "X";
        }
        return ".";
    }

    public void allTestingComplete(TimeMeasurement totalTimeMeasurement) throws IOException {
        super.allTestingComplete(totalTimeMeasurement);
        this.response.add(String.format("--------\n%d Tests,\t%d Failures\t%.03f seconds.\n", this.testCount, this.failCount, totalTimeMeasurement.elapsedSeconds()));
    }
}

