/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.slimResponder;

import fitnesse.FitNesseContext;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.run.slimResponder.HtmlSlimResponder;
import fitnesse.responders.run.slimResponder.HtmlSlimResponderTest;
import fitnesse.responders.run.slimResponder.SlimResponder;
import fitnesse.slim.SlimClient;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.SlimTestSystem;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.TableScanner;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HtmlSlimResponderTest {
    private WikiPage root;
    private PageCrawler crawler;
    private FitNesseContext context;
    private MockRequest request;
    protected SlimResponder responder;
    private WikiPage testPage;
    public String testResults;
    protected SimpleResponse response;
    private TestSystemListener dummyListener = new DummyListener(null);

    private void assertTestResultsContain(String fragment) {
        String unescapedResults = this.unescape(this.testResults);
        Assert.assertTrue((String)unescapedResults, (boolean)unescapedResults.contains(fragment));
    }

    private void assertTestResultsDoNotContain(String fragment) {
        String unescapedResults;
        Assert.assertTrue((String)unescapedResults, (!(unescapedResults = this.unescape(this.testResults)).contains(fragment) ? 1 : 0) != 0);
    }

    private void getResultsForPageContents(String pageContents) throws Exception {
        this.request.setResource("TestPage");
        PageData data = this.testPage.getData();
        data.setContent(data.getContent() + "\n" + pageContents);
        this.testPage.commit(data);
        this.response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        this.testResults = this.response.getContent();
    }

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.crawler = this.root.getPageCrawler();
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.request = new MockRequest();
        this.responder = this.getSlimResponder();
        this.responder.setFastTest(true);
        this.testPage = this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"), "!define TEST_RUNNER {fitnesse.slim.SlimService}\n!path classes");
        SlimTestSystem.SlimDescriptor.clearSlimPortOffset();
    }

    protected SlimResponder getSlimResponder() {
        return new HtmlSlimResponder();
    }

    @Test
    public void slimResponderStartsAndQuitsSlim() throws Exception {
        this.responder.setFastTest(false);
        this.request.setResource("TestPage");
        this.responder.makeResponse(this.context, (Request)this.request);
        Assert.assertTrue((!this.responder.slimOpen() ? 1 : 0) != 0);
    }

    @Test
    public void verboseOutputIfSlimFlagSet() throws Exception {
        this.getResultsForPageContents("!define SLIM_FLAGS {-v}\n");
        Assert.assertTrue((boolean)this.responder.getCommandLine().contains("fitnesse.slim.SlimService -v"));
    }

    @Test
    public void tableWithoutPrefixWillBeConstructed() throws Exception {
        this.getResultsForPageContents("|XX|\n");
        this.assertTestResultsContain("<td>XX <span class=\"error\">Could not invoke constructor for XX[0]</span></td>");
    }

    @Test
    public void emptyQueryTable() throws Exception {
        this.getResultsForPageContents("|Query:x|\n");
        this.assertTestResultsContain("Query tables must have at least two rows.");
    }

    @Test
    public void queryFixtureHasNoQueryFunction() throws Exception {
        this.getResultsForPageContents("!|Query:fitnesse.slim.test.TestSlim|\n|x|y|\n");
        this.assertTestResultsContain("Method query[0] not found in fitnesse.slim.test.TestSlim");
    }

    @Test
    public void emptyOrderedQueryTable() throws Exception {
        this.getResultsForPageContents("|ordered query:x|\n");
        this.assertTestResultsContain("Query tables must have at least two rows.");
    }

    @Test
    public void orderedQueryFixtureHasNoQueryFunction() throws Exception {
        this.getResultsForPageContents("!|ordered query:fitnesse.slim.test.TestSlim|\n|x|y|\n");
        this.assertTestResultsContain("Method query[0] not found in fitnesse.slim.test.TestSlim");
    }

    @Test
    public void emptySubsetQueryTable() throws Exception {
        this.getResultsForPageContents("|subset query:x|\n");
        this.assertTestResultsContain("Query tables must have at least two rows.");
    }

    @Test
    public void subsetQueryFixtureHasNoQueryFunction() throws Exception {
        this.getResultsForPageContents("!|subset query:fitnesse.slim.test.TestSlim|\n|x|y|\n");
        this.assertTestResultsContain("Method query[0] not found in fitnesse.slim.test.TestSlim");
    }

    @Test
    public void scriptTableWithBadConstructor() throws Exception {
        this.getResultsForPageContents("!|Script|NoSuchClass|\n");
        this.assertTestResultsContain("<span class=\"error\">Could not invoke constructor for NoSuchClass");
    }

    @Test
    public void emptyImportTable() throws Exception {
        this.getResultsForPageContents("|Import|\n");
        this.assertTestResultsContain("Import tables must have at least two rows.");
    }

    @Test
    public void emptyTableTable() throws Exception {
        this.getResultsForPageContents("!|Table:TableFixture|\n");
        this.assertTestResultsContain("<span class=\"error\">Could not invoke constructor for TableFixture[0]</span>");
    }

    @Test
    public void tableFixtureHasNoDoTableFunction() throws Exception {
        this.getResultsForPageContents("!|Table:fitnesse.slim.test.TestSlim|\n|a|b|\n");
        this.assertTestResultsContain("Method doTable[1] not found in fitnesse.slim.test.TestSlim.");
    }

    @Test
    public void simpleDecisionTable() throws Exception {
        this.getResultsForPageContents("!|DT:fitnesse.slim.test.TestSlim|\n|returnInt?|\n|7|\n");
        this.assertTestResultsContain("<span class=\"pass\">7</span>");
    }

    @Test
    public void decisionTableIgnoresMethodMissingForResetExecuteAndTable() throws Exception {
        this.getResultsForPageContents("!|DT:fitnesse.slim.test.DummyDecisionTable|\n|x?|\n|1|\n");
        Assert.assertEquals((long)0L, (long)this.responder.getTestSummary().getExceptions());
    }

    @Test
    public void decisionTableWithNoResetDoesNotCountExceptionsForExecute() throws Exception {
        this.getResultsForPageContents("!|DT:fitnesse.slim.test.DummyDecisionTableWithExecuteButNoReset|\n|x?|\n|1|\n");
        Assert.assertEquals((long)0L, (long)this.responder.getTestSummary().getExceptions());
    }

    @Test
    public void queryTableWithoutTableFunctionIgnoresMissingMethodException() throws Exception {
        this.getResultsForPageContents("!|query:fitnesse.slim.test.DummyQueryTableWithNoTableMethod|\n|x|\n|1|\n");
        Assert.assertEquals((long)0L, (long)this.responder.getTestSummary().getExceptions());
    }

    @Test
    public void decisionTableWithExecuteThatThrowsDoesShowsException() throws Exception {
        this.getResultsForPageContents("!|DT:fitnesse.slim.test.DecisionTableExecuteThrows|\n|x?|\n|1|\n");
        Assert.assertEquals((long)1L, (long)this.responder.getTestSummary().getExceptions());
        this.assertTestResultsContain("EXECUTE_THROWS");
    }

    @Test
    public void tableWithException() throws Exception {
        this.getResultsForPageContents("!|DT:NoSuchClass|\n|returnInt?|\n|7|\n");
        this.assertTestResultsContain("<span class=\"error\">Could not invoke constructor for NoSuchClass");
    }

    @Test
    public void tableWithBadConstructorHasException() throws Exception {
        this.getResultsForPageContents("!|DT:fitnesse.slim.test.TestSlim|badArgument|\n|returnConstructorArgument?|\n|3|\n");
        HtmlTableScanner ts = new HtmlTableScanner(this.testPage.getData().getHtml());
        ts.getTable(0);
        this.assertTestResultsContain("Could not invoke constructor");
    }

    @Test
    public void tableWithBadVariableHasException() throws Exception {
        this.getResultsForPageContents("!|DT:fitnesse.slim.test.TestSlim|\n|noSuchVar|\n|3|\n");
        this.assertTestResultsContain("<span class=\"error\">Method setNoSuchVar[1] not found in fitnesse.slim.test.TestSlim");
    }

    @Test
    public void tableWithStopTestMessageException() throws Exception {
        this.getResultsForPageContents("!|DT:fitnesse.slim.test.TestSlim|\n|throwStopTestExceptionWithMessage?|\n| once |\n| twice |\n");
        this.assertTestResultsContain("<td>once <span class=\"fail\">Stop Test</span></td>");
        this.assertTestResultsContain("<td>twice <span class=\"ignore\">Test not run</span>");
    }

    @Test
    public void tableWithMessageException() throws Exception {
        this.getResultsForPageContents("!|DT:fitnesse.slim.test.TestSlim|\n|throwExceptionWithMessage?|\n| once |\n");
        this.assertTestResultsContain("<td>once <span class=\"error\">Test message</span></td>");
    }

    @Test
    public void tableWithStopTestExceptionThrown() throws Exception {
        this.getResultsForPageContents("!|DT:fitnesse.slim.test.TestSlim|\n|throwNormal?| throwStopping? |\n| first | second  |\n| should fail1| true           |\n\n\n!|DT:fitnesse.slim.test.ThrowException|\n|throwNormal?|\n| should fail2|\n");
        this.assertTestResultsContain("<tr class=\"exception closed\">");
        this.assertTestResultsContain("<td class=\"fail\">first</td>");
        this.assertTestResultsContain("<td class=\"fail\">second</td>");
        this.assertTestResultsContain("<tr class=\"exception-detail closed-detail\">");
        this.assertTestResultsContain("<td>should fail1 <span class=\"ignore\">Test not run</span></td>");
        this.assertTestResultsContain("<td>should fail2 <span class=\"ignore\">Test not run</span></td>");
    }

    @Test
    public void tableWithSymbolSubstitution() throws Exception {
        this.getResultsForPageContents("!|DT:fitnesse.slim.test.TestSlim|\n|string|getStringArg?|\n|Bob|$V=|\n|$V|$V|\n");
        TableScanner ts = this.getScannedResults();
        Table dt = ts.getTable(0);
        Assert.assertEquals((Object)"$V<-[Bob]", (Object)this.unescape(dt.getCellContents(1, 2)));
        Assert.assertEquals((Object)"$V->[Bob]", (Object)this.unescape(dt.getCellContents(0, 3)));
    }

    protected TableScanner getScannedResults() throws Exception {
        return new HtmlTableScanner(this.testResults);
    }

    private String unescape(String x) {
        return Utils.unescapeWiki((String)Utils.unescapeHTML((String)x));
    }

    @Test
    public void substituteSymbolIntoExpression() throws Exception {
        this.getResultsForPageContents("!|DT:fitnesse.slim.test.TestSlim|\n|string|getStringArg?|\n|3|$A=|\n|2|<$A|\n|5|$B=|\n|4|$A<_<$B|\n");
        TableScanner ts = this.getScannedResults();
        Table dt = ts.getTable(0);
        Assert.assertEquals((Object)"<span class=\"pass\">2<$A->[3]</span>", (Object)this.unescape(dt.getCellContents(1, 3)));
        Assert.assertEquals((Object)"<span class=\"pass\">$A->[3]<4<$B->[5]</span>", (Object)this.unescape(dt.getCellContents(1, 5)));
    }

    @Test
    public void tableWithExpression() throws Exception {
        this.getResultsForPageContents("!|DT:fitnesse.slim.test.TestSlim|\n|string|getStringArg?|\n|${=3+4=}|7|\n");
        TableScanner ts = this.getScannedResults();
        Table dt = ts.getTable(0);
        Assert.assertEquals((Object)"<span class=\"pass\">7</span>", (Object)dt.getCellContents(1, 2));
    }

    @Test
    public void noSuchConverter() throws Exception {
        this.getResultsForPageContents("|!-DT:fitnesse.slim.test.TestSlim-!|\n|noSuchConverter|noSuchConverter?|\n|x|x|\n");
        TableScanner ts = this.getScannedResults();
        Table dt = ts.getTable(0);
        Assert.assertEquals((Object)"x <span class=\"error\">No converter for fitnesse.slim.test.TestSlim$NoSuchConverter.</span>", (Object)dt.getCellContents(0, 2));
    }

    @Test
    public void returnedListsBecomeStrings() throws Exception {
        this.getResultsForPageContents("!|script|\n|start|fitnesse.slim.test.TestSlim|\n|one list|1,2|\n|check|get list arg|[1, 2]|\n");
        this.assertTestResultsContain("<td><span class=\"pass\">[1, 2]</span></td>");
    }

    @Test
    public void nullStringReturned() throws Exception {
        this.getResultsForPageContents("!|fitnesse.slim.test.TestSlim|\n|nullString?|\n|null|\n");
        this.assertTestResultsContain("<td><span class=\"pass\">null</span></td>");
    }

    @Test
    public void reportableExceptionsAreReported() throws Exception {
        this.getResultsForPageContents("!|fitnesse.slim.test.ExecuteThrowsReportableException|\n|x|\n|1|\n");
        this.assertTestResultsContain("A Reportable Exception");
    }

    @Test
    public void versionMismatchIsNotReported() throws Exception {
        this.getResultsForPageContents("");
        this.assertTestResultsDoNotContain("Slim Protocol Version Error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void versionMismatchIsReported() throws Exception {
        double oldVersionNumber = SlimClient.MINIMUM_REQUIRED_SLIM_VERSION;
        SlimClient.MINIMUM_REQUIRED_SLIM_VERSION = 1000.0;
        try {
            this.getResultsForPageContents("");
            this.assertTestResultsContain("Slim Protocol Version Error");
        }
        finally {
            SlimClient.MINIMUM_REQUIRED_SLIM_VERSION = oldVersionNumber;
        }
    }

    @Test
    public void checkTestClassPrecededByDefine() throws Exception {
        this.getResultsForPageContents("!define PI {3.141592}\n!path classes\n!path fitnesse.jar\n|fitnesse.testutil.PassFixture|\n");
        this.assertTestResultsContain("PassFixture");
    }

    @Test
    public void emptyScenarioTable() throws Exception {
        this.getResultsForPageContents("|Scenario|\n");
        this.assertTestResultsContain("Scenario tables must have a name.");
    }

    @Test
    public void scenarioTableIsRegistered() throws Exception {
        this.getResultsForPageContents("|Scenario|myScenario|\n");
        Assert.assertTrue((String)"scenario should be registered", (boolean)((ScenarioTable)this.responder.testSystem.getTestContext().getScenarios().iterator().next()).getScenarioName().equals("myScenario"));
    }
}

