/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.SlimClient;
import fitnesse.slim.SlimService;
import fitnesse.slim.instructions.CallInstruction;
import fitnesse.slim.instructions.ImportInstruction;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.MakeInstruction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SlimServiceTestBase {
    protected List<Instruction> statements;
    protected SlimClient slimClient;

    protected abstract void startSlimService() throws Exception;

    protected abstract void closeSlimService() throws Exception;

    protected abstract String getImport();

    protected abstract String expectedExceptionMessage();

    protected abstract String expectedStopTestExceptionMessage();

    @Before
    public void setUp() throws InterruptedException, IOException {
        this.createSlimService();
        this.slimClient = new SlimClient("localhost", 8099);
        this.statements = new ArrayList();
        this.slimClient.connect();
    }

    protected void createSlimService() throws InterruptedException {
        while (!this.tryCreateSlimService()) {
            Thread.sleep(10L);
        }
    }

    private boolean tryCreateSlimService() {
        try {
            this.startSlimService();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @After
    public void after() throws Exception {
        this.teardown();
    }

    protected void teardown() throws Exception {
        this.slimClient.sendBye();
        this.slimClient.close();
        this.closeSlimService();
    }

    @Test
    public void emptySession() throws Exception {
        Assert.assertTrue((String)"Connected", (boolean)this.slimClient.isConnected());
    }

    @Test
    public void versionNumberShouldBeDetected() throws Exception {
        double slimVersion = Double.parseDouble("0.3");
        Assert.assertEquals((double)slimVersion, (double)this.slimClient.getServerVersion(), (double)1.0E-4);
    }

    @Test
    public void callOneMethod() throws Exception {
        this.addImportAndMake();
        this.addEchoInt("id", "1");
        Map result = this.slimClient.invokeAndGetResponse(this.statements);
        Assert.assertEquals((Object)"1", result.get("id"));
    }

    private void addEchoInt(String id, String number) {
        this.statements.add(new CallInstruction(id, "testSlim", "echoInt", new Object[]{number}));
    }

    private void addImportAndMake() {
        this.statements.add(new ImportInstruction("i1", this.getImport()));
        this.statements.add(new MakeInstruction("m1", "testSlim", "TestSlim"));
    }

    @Test
    public void makeManyCallsInOrderToTestLongSequencesOfInstructions() throws Exception {
        this.addImportAndMake();
        for (int i = 0; i < 1000; ++i) {
            this.addEchoInt(String.format("id_%d", i), Integer.toString(i));
        }
        Map result = this.slimClient.invokeAndGetResponse(this.statements);
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((long)i, (long)Integer.parseInt((String)result.get(String.format("id_%d", i))));
        }
    }

    @Test
    public void callWithLineBreakInStringArgument() throws Exception {
        this.addImportAndMake();
        this.statements.add(new CallInstruction("id", "testSlim", "echoString", new Object[]{"hello\nworld\n"}));
        Map result = this.slimClient.invokeAndGetResponse(this.statements);
        Assert.assertEquals((Object)"hello\nworld\n", result.get("id"));
    }

    @Test
    public void callWithMultiByteChar() throws Exception {
        this.addImportAndMake();
        this.statements.add(new CallInstruction("id", "testSlim", "echoString", new Object[]{"K\u00f6ln"}));
        Map result = this.slimClient.invokeAndGetResponse(this.statements);
        Assert.assertEquals((Object)"K\u00f6ln", result.get("id"));
    }

    @Test
    public void makeManyIndividualCalls() throws Exception {
        this.addImportAndMake();
        this.slimClient.invokeAndGetResponse(this.statements);
        for (int i = 0; i < 100; ++i) {
            this.statements.clear();
            this.addEchoInt("id", "42");
            Map result = this.slimClient.invokeAndGetResponse(this.statements);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"42", result.get("id"));
        }
    }

    @Test
    public void callFunctionThatDoesntExist() throws Exception {
        this.addImportAndMake();
        this.statements.add(new CallInstruction("id", "testSlim", "noSuchFunction"));
        Map results = this.slimClient.invokeAndGetResponse(this.statements);
        this.assertContainsException("message:<<NO_METHOD_IN_CLASS", "id", results);
    }

    private void assertContainsException(String message, String id, Map<String, Object> results) {
        String result;
        Assert.assertTrue((String)result, ((result = (String)results.get(id)).contains("__EXCEPTION__:") && result.contains(message) ? 1 : 0) != 0);
    }

    @Test
    public void makeClassThatDoesntExist() throws Exception {
        this.statements.add(new MakeInstruction("m1", "me", "NoSuchClass"));
        Map results = this.slimClient.invokeAndGetResponse(this.statements);
        this.assertContainsException("message:<<COULD_NOT_INVOKE_CONSTRUCTOR", "m1", results);
    }

    @Test
    public void useInstanceThatDoesntExist() throws Exception {
        this.addImportAndMake();
        this.statements.add(new CallInstruction("id", "noInstance", "f"));
        Map results = this.slimClient.invokeAndGetResponse(this.statements);
        this.assertContainsException("message:<<NO_INSTANCE", "id", results);
    }

    @Test
    public void verboseArgument() throws Exception {
        String[] args = new String[]{"-v", "99"};
        Assert.assertTrue((boolean)SlimService.parseCommandLine((String[])args));
        Assert.assertTrue((boolean)SlimService.verbose);
    }

    @Test
    public void notStopTestExceptionThrown() throws Exception {
        this.addImportAndMake();
        this.statements.add(new CallInstruction("id", "testSlim", "throwNormal"));
        this.statements.add(new CallInstruction("id2", "testSlim", "throwNormal"));
        Map results = this.slimClient.invokeAndGetResponse(this.statements);
        this.assertContainsException("__EXCEPTION__:" + this.expectedExceptionMessage(), "id", results);
        this.assertContainsException("__EXCEPTION__:" + this.expectedExceptionMessage(), "id2", results);
    }

    @Test
    public void stopTestExceptionThrown() throws Exception {
        this.addImportAndMake();
        this.statements.add(new CallInstruction("id", "testSlim", "throwStopping"));
        this.statements.add(new CallInstruction("id2", "testSlim", "throwNormal"));
        Map results = this.slimClient.invokeAndGetResponse(this.statements);
        this.assertContainsException("__EXCEPTION__:" + this.expectedStopTestExceptionMessage(), "id", results);
        Assert.assertNull(results.get("id2"));
    }

    @Test
    public void canSpecifyAnInteractionClass() {
        SlimService.parseCommandLine((String[])new String[]{"-i", "fitnesse.slim.fixtureInteraction.DefaultInteraction"});
        Assert.assertEquals((Object)"fitnesse.slim.fixtureInteraction.DefaultInteraction", (Object)SlimService.getInteractionClass().getName());
    }

    @Test
    public void canSpecifyAComplexCommandLine() {
        String commandLine = "-v -i fitnesse.slim.fixtureInteraction.DefaultInteraction 7890";
        String[] args = commandLine.split(" ");
        Assert.assertTrue((String)"should parse correctly", (boolean)SlimService.parseCommandLine((String[])args));
        Assert.assertEquals((String)"should have interaction class set", (Object)"fitnesse.slim.fixtureInteraction.DefaultInteraction", (Object)SlimService.getInteractionClass().getName());
        Assert.assertTrue((String)"should be verbose", (boolean)SlimService.verbose);
        Assert.assertEquals((String)"should have set port", (long)7890L, (long)SlimService.port);
    }

    @Test
    public void canSpecifyComplexArgs() {
        String commandLine = "-v -i fitnesse.slim.fixtureInteraction.DefaultInteraction 7890";
        String[] args = commandLine.split(" ");
        Assert.assertTrue((String)"should parse correctly", (boolean)SlimService.parseCommandLine((String[])args));
        Assert.assertEquals((String)"should have interaction class set", (Object)"fitnesse.slim.fixtureInteraction.DefaultInteraction", (Object)SlimService.getInteractionClass().getName());
        Assert.assertTrue((String)"should be verbose", (boolean)SlimService.verbose);
        Assert.assertEquals((String)"should have set port", (long)7890L, (long)SlimService.port);
    }
}

