/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.StackTraceEnricher;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class StackTraceEnricher {
    private Map<String, ClassMetaInformation> elementInformation = new HashMap();

    public void printStackTrace(Throwable throwable) {
        try {
            this.printStackTrace(throwable, (OutputStream)System.err);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printStackTrace(Throwable throwable, OutputStream stream) throws IOException {
        stream.write(this.getStackTraceAsString(throwable).getBytes());
        stream.flush();
    }

    public void printStackTrace(Throwable throwable, Writer writer) throws IOException {
        writer.write(this.getStackTraceAsString(throwable));
        writer.flush();
    }

    public String getStackTraceAsString(Throwable throwable) {
        StringBuffer sb = new StringBuffer();
        Throwable t = throwable;
        if (throwable.getStackTrace() == null || throwable.getStackTrace().length == 0) {
            t = throwable.fillInStackTrace();
        }
        for (StackTraceElement ste : t.getStackTrace()) {
            sb.append("\n\tat ").append(ste.toString());
            ClassMetaInformation cmi = this.getMetaInformation(ste);
            sb.append(" [");
            sb.append(cmi.getLocation());
            if (!cmi.getVersion().equals("n/a")) {
                sb.append(":").append(cmi.getVersion());
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public String getVersion(Class<?> clazz) {
        return this.getMetaInformation(clazz).getVersion();
    }

    public String getVersion(StackTraceElement element) {
        return this.getMetaInformation(element).getVersion();
    }

    public String getLocation(Class<?> clazz) {
        return this.getMetaInformation(clazz).getLocation();
    }

    public String getLocation(StackTraceElement element) {
        return this.getMetaInformation(element).getLocation();
    }

    private ClassMetaInformation getMetaInformation(Class<?> clazz) {
        ClassMetaInformation information;
        if (this.elementInformation.containsKey(clazz.getName())) {
            information = (ClassMetaInformation)this.elementInformation.get(clazz.getName());
        } else {
            information = new ClassMetaInformation(clazz);
            this.elementInformation.put(clazz.getName(), information);
        }
        return information;
    }

    private ClassMetaInformation getMetaInformation(StackTraceElement element) {
        ClassMetaInformation information;
        if (this.elementInformation.containsKey(element.getClassName())) {
            information = (ClassMetaInformation)this.elementInformation.get(element.getClassName());
        } else {
            information = new ClassMetaInformation(element);
            this.elementInformation.put(element.getClassName(), information);
        }
        return information;
    }
}

