/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.FixtureMethodExecutor;
import fitnesse.slim.Library;
import fitnesse.slim.LibraryMethodExecutor;
import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.MethodExecutionResults;
import fitnesse.slim.MethodExecutor;
import fitnesse.slim.SlimError;
import fitnesse.slim.SlimException;
import fitnesse.slim.SlimExecutionContext;
import fitnesse.slim.SlimHelperLibrary;
import fitnesse.slim.StatementExecutorConsumer;
import fitnesse.slim.StatementExecutorInterface;
import fitnesse.slim.SystemUnderTestMethodExecutor;
import fitnesse.slim.converters.MapEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StatementExecutor
implements StatementExecutorInterface {
    private static final String SLIM_HELPER_LIBRARY_INSTANCE_NAME = "SlimHelperLibrary";
    private boolean stopRequested = false;
    private SlimExecutionContext context;
    private List<MethodExecutor> executorChain = new ArrayList();

    public StatementExecutor() {
        this(null);
    }

    public StatementExecutor(SlimExecutionContext context) {
        PropertyEditorManager.registerEditor(Map.class, MapEditor.class);
        this.context = context == null ? new SlimExecutionContext() : context;
        this.executorChain.add(new FixtureMethodExecutor(this.context));
        this.executorChain.add(new SystemUnderTestMethodExecutor(this.context));
        this.executorChain.add(new LibraryMethodExecutor(this.context));
        this.addSlimHelperLibraryToLibraries();
    }

    private void addSlimHelperLibraryToLibraries() {
        SlimHelperLibrary slimHelperLibrary = new SlimHelperLibrary();
        slimHelperLibrary.setStatementExecutor((StatementExecutorInterface)this);
        this.context.addLibrary(new Library(SLIM_HELPER_LIBRARY_INSTANCE_NAME, (Object)slimHelperLibrary));
    }

    public Object getInstance(String instanceName) {
        return this.context.getInstance(instanceName);
    }

    public void setInstance(String actorInstanceName, Object actor) {
        this.context.setInstance(actorInstanceName, actor);
    }

    public void addPath(String path) throws SlimException {
        this.context.addPath(path);
    }

    public void setVariable(String name, Object value) {
        this.context.setVariable(name, value);
    }

    public void create(String instanceName, String className, Object ... args) throws SlimException {
        try {
            this.context.create(instanceName, className, args);
            Object newInstance = this.context.getInstance(instanceName);
            if (newInstance instanceof StatementExecutorConsumer) {
                ((StatementExecutorConsumer)newInstance).setStatementExecutor((StatementExecutorInterface)this);
            }
        }
        catch (SlimError e) {
            throw new SlimException(String.format("%s[%d]", className, args.length), (Throwable)e, "COULD_NOT_INVOKE_CONSTRUCTOR", true);
        }
        catch (IllegalArgumentException e) {
            throw new SlimException(String.format("%s[%d]", className, args.length), (Throwable)e, "COULD_NOT_INVOKE_CONSTRUCTOR", true);
        }
        catch (InvocationTargetException e) {
            throw new SlimException(e.getTargetException(), true);
        }
        catch (Throwable e) {
            this.checkExceptionForStop(e);
            throw new SlimException(e);
        }
    }

    public Object call(String instanceName, String methodName, Object ... args) throws SlimException {
        try {
            return this.getMethodExecutionResult(instanceName, methodName, args).returnValue();
        }
        catch (Throwable e) {
            this.checkExceptionForStop(e);
            throw new SlimException(e);
        }
    }

    public Object callAndAssign(String variable, String instanceName, String methodName, Object ... args) throws SlimException {
        try {
            MethodExecutionResult result = this.getMethodExecutionResult(instanceName, methodName, args);
            this.context.setVariable(variable, result);
            return result.returnValue();
        }
        catch (Throwable e) {
            this.checkExceptionForStop(e);
            throw new SlimException(e);
        }
    }

    private MethodExecutionResult getMethodExecutionResult(String instanceName, String methodName, Object ... args) throws Throwable {
        MethodExecutionResults results = new MethodExecutionResults();
        for (int i = 0; i < this.executorChain.size(); ++i) {
            MethodExecutionResult result = ((MethodExecutor)this.executorChain.get(i)).execute(instanceName, methodName, this.context.replaceSymbols(args));
            if (result.hasResult()) {
                return result;
            }
            results.add(result);
        }
        return results.getFirstResult();
    }

    private void checkExceptionForStop(Throwable exception) {
        if (exception.getClass().toString().contains("StopTest")) {
            this.stopRequested = true;
        }
    }

    public boolean stopHasBeenRequested() {
        return this.stopRequested;
    }

    public void reset() {
        this.stopRequested = false;
    }
}

