/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.SlimError;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSystem;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.slim.HtmlTable;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.SlimTestSystem;
import fitnesse.testsystems.slim.TableScanner;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.wiki.ReadOnlyPageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.ParsedPage;
import java.util.List;
import org.htmlparser.Parser;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class HtmlSlimTestSystem
extends SlimTestSystem {
    private HtmlTableScanner tableScanner;

    public HtmlSlimTestSystem(WikiPage page, TestSystem.Descriptor descriptor, TestSystemListener listener) {
        super(page, descriptor, listener);
    }

    protected List<SlimTable> createSlimTables(TestPage pageToTest) {
        NodeList nodeList = this.makeNodeList((ReadOnlyPageData)pageToTest.getDecoratedData());
        this.tableScanner = new HtmlTableScanner(new NodeList[]{nodeList});
        return this.createSlimTables((TableScanner)this.tableScanner);
    }

    private NodeList makeNodeList(ReadOnlyPageData pageData) {
        ParsedPage parsedPage = pageData.getParsedPage();
        String html = parsedPage.toHtml();
        Parser parser = new Parser(new Lexer(new Page(html)));
        try {
            return parser.parse(null);
        }
        catch (ParserException e) {
            throw new SlimError((Throwable)e);
        }
    }

    protected String createHtmlResults(SlimTable startWithTable, SlimTable stopBeforeTable) {
        HtmlTable start = startWithTable != null ? (HtmlTable)startWithTable.getTable() : null;
        HtmlTable end = stopBeforeTable != null ? (HtmlTable)stopBeforeTable.getTable() : null;
        return this.tableScanner.toHtml(start, end);
    }
}

