/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.slim.SlimError;
import fitnesse.testsystems.slim.HtmlTable;
import fitnesse.testsystems.slim.TableScanner;
import fitnesse.util.HtmlParserTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class HtmlTableScanner
implements TableScanner<HtmlTable> {
    private List<HtmlTable> tables = new ArrayList(16);
    private List<Node> nodes = new ArrayList(512);

    public HtmlTableScanner(String page) {
        NodeList htmlTree;
        if (page == null || page.equals("")) {
            page = "<i>This page intentionally left blank.</i>";
        }
        try {
            Parser parser = new Parser(new Lexer(new Page(page)));
            htmlTree = parser.parse(null);
        }
        catch (ParserException e) {
            throw new SlimError((Throwable)e);
        }
        this.scanForTables(htmlTree);
    }

    public HtmlTableScanner(NodeList ... nodeLists) {
        for (NodeList nodeList : nodeLists) {
            this.scanForTables(nodeList);
        }
    }

    private void scanForTables(NodeList nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node endNode;
            Node node = nodes.elementAt(i);
            if (node instanceof TableTag) {
                TableTag tableTag = (TableTag)HtmlParserTools.deepClone((Node)((TableTag)node));
                this.tables.add(new HtmlTable(tableTag));
                this.nodes.add(tableTag);
                continue;
            }
            this.nodes.add(HtmlParserTools.flatClone((Node)node));
            NodeList children = node.getChildren();
            if (children != null) {
                this.scanForTables(children);
            }
            if ((endNode = HtmlParserTools.endTag((Node)node)) == null) continue;
            this.nodes.add(endNode);
        }
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public HtmlTable getTable(int i) {
        return (HtmlTable)this.tables.get(i);
    }

    public Iterator<HtmlTable> iterator() {
        return this.tables.iterator();
    }

    public String toHtml(HtmlTable startTable, HtmlTable endBeforeTable) {
        int index = 0;
        if (startTable != null) {
            index = this.nodes.indexOf(startTable.getTableNode());
        }
        TableTag endTag = null;
        if (endBeforeTable != null) {
            endTag = endBeforeTable.getTableNode();
        }
        StringBuilder html = new StringBuilder(512);
        for (int i = index; i < this.nodes.size() && this.nodes.get(i) != endTag; ++i) {
            Node node = (Node)this.nodes.get(i);
            html.append(node.toHtml());
        }
        return html.toString();
    }

    public String toHtml() {
        return this.toHtml(null, null);
    }
}

