/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim;

import fitnesse.testsystems.TestSystem;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSystemBaseTest {
    private WikiPage root;
    private PageCrawler crawler;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
    }

    @Test
    public void buildFullySpecifiedTestSystemName() throws Exception {
        WikiPage testPage = this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"), "!define TEST_SYSTEM {system}\n!define TEST_RUNNER {runner}\n");
        String testSystemName = TestSystem.getDescriptor((WikiPage)testPage, null, (boolean)false).getTestSystemName();
        Assert.assertEquals((Object)"system:runner", (Object)testSystemName);
    }

    @Test
    public void buildDefaultTestSystemName() throws Exception {
        WikiPage testPage = this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"), "");
        String testSystemName = TestSystem.getDescriptor((WikiPage)testPage, null, (boolean)false).getTestSystemName();
        Assert.assertEquals((Object)"fit:fit.FitServer", (Object)testSystemName);
    }

    @Test
    public void buildTestSystemNameWhenTestSystemIsSlim() throws Exception {
        WikiPage testPage = this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"), "!define TEST_SYSTEM {slim}\n");
        String testSystemName = TestSystem.getDescriptor((WikiPage)testPage, null, (boolean)false).getTestSystemName();
        Assert.assertEquals((Object)"slim:fitnesse.slim.SlimService", (Object)testSystemName);
    }

    @Test
    public void buildTestSystemNameWhenTestSystemIsUnknownDefaultsToFit() throws Exception {
        WikiPage testPage = this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"), "!define TEST_SYSTEM {X}\n");
        String testSystemName = TestSystem.getDescriptor((WikiPage)testPage, null, (boolean)false).getTestSystemName();
        Assert.assertEquals((Object)"X:fit.FitServer", (Object)testSystemName);
    }
}

