/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.TestResult;
import fitnesse.testsystems.slim.tables.QueryTable;

public class OrderedQueryTable
extends QueryTable {
    private int lastMatchedRow = -1;

    public OrderedQueryTable(Table table, String tableId, SlimTestContext slimTestContext) {
        super(table, tableId, slimTestContext);
    }

    protected void scanRowForMatch(int tableRow, QueryTable.QueryResults queryResults) {
        int matchedRow = queryResults.findBestMatch(tableRow);
        if (matchedRow == -1) {
            this.replaceAllvariablesInRow(tableRow);
            TestResult testResult = TestResult.fail(null, (String)this.table.getCellContents(0, tableRow), (String)"missing");
            this.table.updateContent(0, tableRow, testResult);
        } else {
            int columns = this.table.getColumnCountInRow(tableRow);
            this.markColumns(tableRow, matchedRow, columns, queryResults);
            this.lastMatchedRow = matchedRow;
        }
    }

    private void markColumns(int tableRow, int matchedRow, int columns, QueryTable.QueryResults queryResults) {
        for (int col = 0; col < columns; ++col) {
            this.markField(tableRow, matchedRow, col, queryResults);
        }
    }

    protected TestResult markMatch(int tableRow, int matchedRow, int col, String message) {
        TestResult testResult = col == 0 && matchedRow <= this.lastMatchedRow ? TestResult.fail(null, (String)message, (String)("out of order: row " + (matchedRow + 1))) : TestResult.pass((String)message);
        return testResult;
    }
}

