/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.TestResult;
import fitnesse.testsystems.slim.tables.DecisionTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReturnedValueExpectationTest {
    private SlimTestContextImpl testContext;

    @Before
    public void setup() {
        this.testContext = new SlimTestContextImpl();
    }

    private void assertExpectationMessage(String expected, String value, String message) throws Exception {
        DecisionTable slimTable;
        HtmlTableScanner ts = new HtmlTableScanner("<table><tr><td>x</td></tr></table>");
        Table t = ts.getTable(0);
        DecisionTable decisionTable = slimTable = new DecisionTable(t, "id", (SlimTestContext)this.testContext);
        decisionTable.getClass();
        SlimTable.ReturnedValueExpectation expectation = new SlimTable.ReturnedValueExpectation((SlimTable)decisionTable, 0, 0);
        TestResult testResult = expectation.evaluationMessage(value, expected);
        Assert.assertEquals((Object)message, (Object)testResult.toString(expected));
        Assert.assertEquals((long)0L, (long)expectation.getRow());
        Assert.assertEquals((long)0L, (long)expectation.getCol());
    }

    @Test
    public void passingMessage() throws Exception {
        this.assertExpectationMessage("expected", "expected", "pass(expected)");
    }

    @Test
    public void failingMesage() throws Exception {
        this.assertExpectationMessage("expected", "actual", "fail(a=actual;e=expected)");
    }

    @Test
    public void evaluationMessageForBlankInput() throws Exception {
        this.assertExpectationMessage("", "", "pass(BLANK)");
    }

    @Test
    public void evaluationMessageForBlankExpectation() throws Exception {
        this.assertExpectationMessage("", "ignore", "ignore(ignore)");
    }

    @Test
    public void matchedSymbolIsReplaced() throws Exception {
        this.testContext.setSymbol("S", "Value");
        this.assertExpectationMessage("$S", "Value", "pass($S->[Value])");
    }

    @Test
    public void mismatchedSymbolIsReplaced() throws Exception {
        this.testContext.setSymbol("S", "Value");
        this.assertExpectationMessage("$S", "WrongValue", "fail(a=WrongValue;e=$S->[Value])");
    }

    @Test
    public void matchedUnboundSymbolIsNotReplaced() throws Exception {
        this.assertExpectationMessage("$S", "$S", "pass($S)");
    }

    @Test
    public void mismatchedUnboundSymbolIsNotReplaced() throws Exception {
        this.assertExpectationMessage("$S", "$X", "fail(a=$X;e=$S)");
    }

    @Test
    public void lessThanComparisons() throws Exception {
        this.assertExpectationMessage(" < 5.2", "3", "pass(3<5.2)");
        this.assertExpectationMessage(" < 5.2", "2", "pass(2<5.2)");
        this.assertExpectationMessage(" < 5.2", "6", "fail(6<5.2)");
        this.assertExpectationMessage(" < 5.2", "2.8", "pass(2.8<5.2)");
    }

    @Test
    public void NotGEComparisons() throws Exception {
        this.assertExpectationMessage(" !>= 5.2", "3", "pass(3!>=5.2)");
        this.assertExpectationMessage(" !>= 5.2", "2", "pass(2!>=5.2)");
        this.assertExpectationMessage(" !>= 5.2", "6", "fail(6!>=5.2)");
        this.assertExpectationMessage(" !>= 5.2", "2.8", "pass(2.8!>=5.2)");
    }

    @Test
    public void greaterThanComparison() throws Exception {
        this.assertExpectationMessage(" > 5.9", "8", "pass(8>5.9)");
        this.assertExpectationMessage(" > 5.9", "3.6", "fail(3.6>5.9)");
    }

    @Test
    public void notLEComparison() throws Exception {
        this.assertExpectationMessage(" !<= 5.9", "8", "pass(8!<=5.9)");
        this.assertExpectationMessage(" !<= 5.9", "3.6", "fail(3.6!<=5.9)");
    }

    @Test
    public void approximatelyEquals() throws Exception {
        this.assertExpectationMessage("~= 3.0", "2.95", "pass(2.95~=3.0)");
        this.assertExpectationMessage("~= 3.0", "2.8", "fail(2.8~=3.0)");
    }

    @Test
    public void notApproximatelyEqual() throws Exception {
        this.assertExpectationMessage("!~= 3.0", "2.95", "fail(2.95!~=3.0)");
        this.assertExpectationMessage("!~= 3.0", "2.8", "pass(2.8!~=3.0)");
    }

    @Test
    public void notEqualComparison() throws Exception {
        this.assertExpectationMessage(" != 5.9", "8", "pass(8!=5.9)");
        this.assertExpectationMessage(" != 5.9", "5.9", "fail(5.9!=5.9)");
    }

    @Test
    public void equalComparison() throws Exception {
        this.assertExpectationMessage("=3", "03", "pass(03=3)");
        this.assertExpectationMessage("=3", " 3 ", "pass( 3 =3)");
        this.assertExpectationMessage("=3", ".2", "fail(.2=3)");
        this.assertExpectationMessage("=3.1", "3.1", "pass(3.1=3.1)");
        this.assertExpectationMessage("=3.1", "3.10001", "fail(3.10001=3.1)");
    }

    @Test
    public void greaterOrEqualComparison() throws Exception {
        this.assertExpectationMessage(" >=  5.9 ", "8", "pass(8>=5.9)");
        this.assertExpectationMessage(" >=  5.9 ", "5.9", "pass(5.9>=5.9)");
        this.assertExpectationMessage(" >=  5.9 ", "3.6", "fail(3.6>=5.9)");
    }

    @Test
    public void notLessThanComparison() throws Exception {
        this.assertExpectationMessage(" !<  5.9 ", "8", "pass(8!<5.9)");
        this.assertExpectationMessage(" !<  5.9 ", "5.9", "pass(5.9!<5.9)");
        this.assertExpectationMessage(" !<  5.9 ", "3.6", "fail(3.6!<5.9)");
    }

    @Test
    public void lessOrEqualComparison() throws Exception {
        this.assertExpectationMessage(" <= 5.9 ", "2", "pass(2<=5.9)");
        this.assertExpectationMessage(" <= 5.9 ", "5.9", "pass(5.9<=5.9)");
        this.assertExpectationMessage(" <= 5.9 ", "8.3", "fail(8.3<=5.9)");
    }

    @Test
    public void notGreaterThanComparison() throws Exception {
        this.assertExpectationMessage(" !> 5.9 ", "2", "pass(2!>5.9)");
        this.assertExpectationMessage(" !> 5.9 ", "5.9", "pass(5.9!>5.9)");
        this.assertExpectationMessage(" !> 5.9 ", "8.3", "fail(8.3!>5.9)");
    }

    @Test
    public void openIntervalComparison() throws Exception {
        this.assertExpectationMessage(" 2.1 < _ < 5.9", "4.3", "pass(2.1<4.3<5.9)");
        this.assertExpectationMessage(" 2.1 < _ < 5.9", "2.1", "fail(2.1<2.1<5.9)");
        this.assertExpectationMessage(" 2.1 < _ < 5.9", "8.3", "fail(2.1<8.3<5.9)");
    }

    @Test
    public void closedLeftIntervalComparison() throws Exception {
        this.assertExpectationMessage(" 2.1 <= _ < 5.9", "4.3", "pass(2.1<=4.3<5.9)");
        this.assertExpectationMessage(" 2.1 <= _ < 5.9", "2.1", "pass(2.1<=2.1<5.9)");
        this.assertExpectationMessage(" 2.1 <= _ < 5.9", "8.3", "fail(2.1<=8.3<5.9)");
    }

    @Test
    public void closedRightIntervalComparison() throws Exception {
        this.assertExpectationMessage(" 2.1 < _ <= 5.9", "4.3", "pass(2.1<4.3<=5.9)");
        this.assertExpectationMessage(" 2.1 < _ <= 5.9", "2.1", "fail(2.1<2.1<=5.9)");
        this.assertExpectationMessage(" 2.1 < _ <= 5.9", "5.9", "pass(2.1<5.9<=5.9)");
        this.assertExpectationMessage(" 2.1 < _ <= 5.9", "8.3", "fail(2.1<8.3<=5.9)");
    }

    @Test
    public void negativeNumberInSimpleComparison() throws Exception {
        this.assertExpectationMessage(" < -2 ", "-3", "pass(-3<-2)");
        this.assertExpectationMessage(" < -3 ", "-2", "fail(-2<-3)");
    }

    @Test
    public void negativeNumberInRangeComparison() throws Exception {
        this.assertExpectationMessage(" -4 < _ < -2", "-3", "pass(-4<-3<-2)");
        this.assertExpectationMessage(" -4 < _ < -2", "3", "fail(-4<3<-2)");
    }

    @Test
    public void simpleRegularExpression() throws Exception {
        this.assertExpectationMessage("=~/Bob/", "Bob", "pass(/Bob/ found in: Bob)");
    }

    @Test
    public void regularExpressionMatchesSomethingInsideActualResult() throws Exception {
        this.assertExpectationMessage("=~/Bob/", "My name is Bob Martin", "pass(/Bob/ found in: My name is Bob Martin)");
    }

    @Test
    public void complexRegularExpressionMatches() throws Exception {
        this.assertExpectationMessage("=~/B.b/", "Oh Bob, how could you.", "pass(/B.b/ found in: Oh Bob, how could you.)");
    }

    @Test
    public void simpleRegexFails() throws Exception {
        this.assertExpectationMessage("=~/Bob/", "Pete", "fail(/Bob/ not found in: Pete)");
    }
}

