/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.CallAndAssignInstruction;
import fitnesse.slim.instructions.CallInstruction;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.MakeInstruction;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.Expectation;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.ListUtility;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class SlimTable {
    private static final Pattern SYMBOL_ASSIGNMENT_PATTERN = Pattern.compile("\\A\\s*\\$(\\w+)\\s*=\\s*\\Z");
    private String tableName;
    private int instructionNumber = 0;
    private List<SlimTable> children = new LinkedList();
    private SlimTable parent = null;
    private SlimTestContext testContext;
    protected final Table table;
    protected String id;

    public SlimTable(Table table, String id, SlimTestContext testContext) {
        this.id = id;
        this.table = table;
        this.testContext = testContext;
        this.tableName = this.getTableType() + "_" + id;
    }

    public SlimTable getParent() {
        return this.parent;
    }

    public void addChildTable(SlimTable slimtable, int row) {
        slimtable.id = this.id + "." + this.children.size();
        slimtable.tableName = this.makeInstructionTag(this.instructionNumber) + "/" + slimtable.tableName;
        ++this.instructionNumber;
        slimtable.parent = this;
        this.children.add(slimtable);
        Table parentTable = this.getTable();
        Table childTable = slimtable.getTable();
        parentTable.appendChildTable(row, childTable);
    }

    public String replaceSymbols(String s) {
        return new SymbolReplacer(this, s).replace();
    }

    public String replaceSymbolsWithFullExpansion(String s) {
        return new FullExpansionSymbolReplacer(this, s).replace();
    }

    protected abstract String getTableType();

    public abstract List<Assertion> getAssertions() throws SyntaxError;

    protected String makeInstructionTag() {
        return this.makeInstructionTag(this.instructionNumber++);
    }

    protected String makeInstructionTag(int instructionNumber) {
        return String.format("%s_%d", this.tableName, instructionNumber);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSymbol(String variableName) {
        return this.testContext.getSymbol(variableName);
    }

    public void setSymbol(String variableName, String value) {
        this.testContext.setSymbol(variableName, value);
    }

    public Table getTable() {
        return this.table;
    }

    protected Assertion constructFixture(String fixtureName) {
        return this.constructInstance(this.getTableName(), fixtureName, 0, 0);
    }

    protected String getFixtureName() {
        String tableHeader = this.table.getCellContents(0, 0);
        String fixtureName = this.getFixtureName(tableHeader);
        String disgracedFixtureName = Disgracer.disgraceClassName((String)fixtureName);
        return disgracedFixtureName;
    }

    protected String getFixtureName(String tableHeader) {
        if (!tableHeader.contains(":")) {
            return tableHeader;
        }
        return tableHeader.split(":")[1];
    }

    protected Assertion constructInstance(String instanceName, String className, int classNameColumn, int row) {
        ConstructionExpectation expectation = new ConstructionExpectation(this, classNameColumn, row);
        return this.makeAssertion((Instruction)new MakeInstruction(this.makeInstructionTag(), instanceName, className, this.gatherConstructorArgumentsStartingAt(classNameColumn + 1, row)), (Expectation)expectation);
    }

    protected final Assertion makeAssertion(Instruction instruction, Expectation expectation) {
        return new Assertion(instruction, expectation);
    }

    protected Object[] gatherConstructorArgumentsStartingAt(int startingColumn, int row) {
        int columnCount = this.table.getColumnCountInRow(row);
        ArrayList<String> arguments = new ArrayList<String>();
        for (int col = startingColumn; col < columnCount; ++col) {
            arguments.add(this.table.getCellContents(col, row));
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    protected Instruction callFunction(String instanceName, String functionName, Object ... args) {
        return new CallInstruction(this.makeInstructionTag(), instanceName, Disgracer.disgraceMethodName((String)functionName), args);
    }

    protected Instruction callAndAssign(String symbolName, String instanceName, String functionName, String ... args) {
        return new CallAndAssignInstruction(this.makeInstructionTag(), symbolName, instanceName, Disgracer.disgraceMethodName((String)functionName), (Object[])args);
    }

    protected String ifSymbolAssignment(int col, int row) {
        String expected = this.table.getCellContents(col, row);
        Matcher matcher = SYMBOL_ASSIGNMENT_PATTERN.matcher(expected);
        return matcher.find() ? matcher.group(1) : null;
    }

    public SlimTestContext getTestContext() {
        return this.testContext;
    }

    protected List<Object> tableAsList() {
        List tableArgument = ListUtility.list();
        int rows = this.table.getRowCount();
        for (int row = 1; row < rows; ++row) {
            tableArgument.add(this.tableRowAsList(row));
        }
        return tableArgument;
    }

    private List<Object> tableRowAsList(int row) {
        List rowList = ListUtility.list();
        int cols = this.table.getColumnCountInRow(row);
        for (int col = 0; col < cols; ++col) {
            rowList.add(this.table.getCellContents(col, row));
        }
        return rowList;
    }

    public List<SlimTable> getChildren() {
        return this.children;
    }
}

