/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.testutil.SimpleCachinePage;
import fitnesse.wiki.CachingPage;
import fitnesse.wiki.CachingPageTest;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CachingPageTest {
    private CachingPage root;
    private PageCrawler crawler;
    private WikiPagePath pageOnePath;
    private WikiPagePath childOnePath;
    private WikiPagePath rootPath;

    @Before
    public void setUp() throws Exception {
        this.root = new SimpleCachinePage("RooT", null);
        this.crawler = this.root.getPageCrawler();
        this.pageOnePath = PathParser.parse((String)".PageOne");
        this.childOnePath = PathParser.parse((String)".PageOne.ChildOne");
        this.rootPath = PathParser.parse((String)"root");
    }

    @Test
    public void testCreate() throws Exception {
        String alpha = "AlphaAlpha";
        WikiPage root = InMemoryPage.makeRoot((String)"root");
        Assert.assertFalse((boolean)root.hasChildPage(alpha));
        this.crawler.addPage(root, PathParser.parse((String)alpha), "content");
        Assert.assertTrue((boolean)root.hasChildPage(alpha));
    }

    @Test
    public void testTwoLevel() throws Exception {
        String alpha = "AlphaAlpha";
        String beta = "BetaBeta";
        WikiPage subPage1 = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)alpha));
        this.crawler.addPage(subPage1, PathParser.parse((String)beta));
        Assert.assertTrue((boolean)this.crawler.pageExists((WikiPage)this.root, PathParser.parse((String)(alpha + "." + beta))));
    }

    @Test
    public void testDoubleDot() throws Exception {
        String alpha = "AlphaAlpha";
        String beta = "BetaBeta";
        WikiPage subPage1 = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)alpha));
        this.crawler.addPage(subPage1, PathParser.parse((String)beta));
        Assert.assertFalse((boolean)this.crawler.pageExists((WikiPage)this.root, PathParser.parse((String)(alpha + ".." + beta))));
    }

    @Test
    public void testClearPage() throws Exception {
        String child = "ChildPage";
        this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)child), "content");
        Assert.assertTrue((boolean)this.root.hasCachedSubpage(child));
        this.root.removeChildPage(child);
        Assert.assertFalse((boolean)this.root.hasCachedSubpage(child));
    }

    @Test
    public void testGetName() throws Exception {
        WikiPage frontPage = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"FrontPage"), "FrontPage");
        WikiPage c1 = this.crawler.addPage(frontPage, PathParser.parse((String)"ChildOne"), "ChildOne");
        Assert.assertEquals((Object)"ChildOne", (Object)c1.getName());
        Assert.assertEquals((Object)PathParser.parse((String)"FrontPage.ChildOne"), (Object)this.crawler.getFullPath(c1));
    }

    @Test
    public void testDefaultAttributes() throws Exception {
        WikiPage page = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"SomePage"));
        Assert.assertTrue((boolean)page.getData().hasAttribute("Edit"));
        Assert.assertTrue((boolean)page.getData().hasAttribute("Search"));
        Assert.assertFalse((boolean)page.getData().hasAttribute("Test"));
        Assert.assertFalse((boolean)page.getData().hasAttribute("TestSuite"));
    }

    @Test
    public void testPageDataIsCached() throws Exception {
        CachingPage.cacheTime = 100;
        CachingPage page = (CachingPage)this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"PageOne"), "some content");
        PageData data1 = page.getCachedData();
        PageData data2 = page.getCachedData();
        Thread.sleep(200L);
        PageData data3 = page.getData();
        Assert.assertSame((Object)data1, (Object)data2);
        Assert.assertNotSame((Object)data1, (Object)data3);
    }

    @Test
    public void testDumpCachedExpiredData() throws Exception {
        CachingPage.cacheTime = 100;
        CachingPage page = (CachingPage)this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"PageOne"), "some content");
        PageData data = page.getData();
        Assert.assertNotNull((Object)data);
        Thread.sleep(200L);
        page.dumpExpiredCachedData();
        Assert.assertNull((Object)page.getCachedData());
    }

    @Test
    public void testGetPageThatStartsWithDot() throws Exception {
        WikiPage page1 = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"PageOne"), "page one");
        WikiPage child1 = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"PageOne.ChildOne"), "child one");
        Assert.assertSame((Object)page1, (Object)this.crawler.getPage(page1, this.pageOnePath));
        Assert.assertSame((Object)child1, (Object)this.crawler.getPage(page1, this.childOnePath));
        Assert.assertSame((Object)page1, (Object)this.crawler.getPage(child1, this.pageOnePath));
    }

    @Test
    public void testGetPageUsingRootKeyWord() throws Exception {
        WikiPage page1 = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"PageOne"), "page one");
        Assert.assertSame((Object)this.root, (Object)this.crawler.getPage(page1, this.rootPath));
        Assert.assertSame((Object)this.root, (Object)this.crawler.getPage((WikiPage)this.root, this.rootPath));
    }

    @Test
    public void testEquals() throws Exception {
        WikiPage root = InMemoryPage.makeRoot((String)"RooT");
        WikiPage pageOne = this.crawler.addPage(root, PathParser.parse((String)"PageOne"), "content");
        Assert.assertEquals((Object)pageOne, (Object)pageOne);
        root.removeChildPage("PageOne");
        WikiPage pageOneOne = this.crawler.addPage(root, PathParser.parse((String)"PageOne"));
        Assert.assertEquals((Object)pageOne, (Object)pageOneOne);
    }

    @Test
    public void testCachedDataIsTrashedBeforeOutOfMemoryError() throws Exception {
        CachingPage page = (CachingPage)this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"SomePage"), "some content");
        page.getData();
        Assert.assertTrue((page.getCachedData() != null ? 1 : 0) != 0);
        boolean exceptionThrown = false;
        try {
            new MemoryEater(this);
        }
        catch (OutOfMemoryError e) {
            Assert.assertTrue((page.getCachedData() == null ? 1 : 0) != 0);
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }
}

