/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.Clock;

/*
 * Exception performing whole class analysis ignored.
 */
public class VersionInfo
implements Comparable<VersionInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Pattern COMPEX_NAME_PATTERN = Pattern.compile("(?:([a-zA-Z][^\\-]*)-)?(?:\\d+-)?(\\d{14})");
    private static int counter = 0;
    private String name;
    private String author;
    private Date creationTime;

    public static SimpleDateFormat makeVersionTimeFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }

    public static int nextId() {
        return counter++;
    }

    public VersionInfo(String name, String author, Date creationTime) {
        this.name = name;
        this.author = author;
        this.creationTime = new Date(creationTime.getTime());
    }

    public VersionInfo(String complexName) {
        this(complexName, "", Clock.currentDate());
        Matcher match = COMPEX_NAME_PATTERN.matcher(complexName);
        if (match.find()) {
            this.author = match.group(1);
            if (this.author == null) {
                this.author = "";
            }
            try {
                this.creationTime = VersionInfo.makeVersionTimeFormat().parse(match.group(2));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getCreationTime() {
        return new Date(this.creationTime.getTime());
    }

    public String getName() {
        return this.name;
    }

    public String getAge() {
        Date now = new GregorianCalendar().getTime();
        return VersionInfo.howLongAgoString((Date)now, (Date)this.getCreationTime());
    }

    public static String getVersionNumber(String complexName) {
        Matcher match = COMPEX_NAME_PATTERN.matcher(complexName);
        match.find();
        return match.group(2);
    }

    public static String howLongAgoString(Date now, Date then) {
        long time = Math.abs(now.getTime() - then.getTime()) / 1000L;
        if (time < 60L) {
            return VersionInfo.pluralize((long)time, (String)"second");
        }
        if (time < 3600L) {
            return VersionInfo.pluralize((long)(time / 60L), (String)"minute");
        }
        if (time < 86400L) {
            return VersionInfo.pluralize((long)(time / 3600L), (String)"hour");
        }
        if (time < 31536000L) {
            return VersionInfo.pluralize((long)(time / 86400L), (String)"day");
        }
        return VersionInfo.pluralize((long)(time / 31536000L), (String)"year");
    }

    private static String pluralize(long time, String unit) {
        String age = time + " " + unit;
        if (time > 1L) {
            age = age + "s";
        }
        return age;
    }

    @Override
    public int compareTo(VersionInfo o) {
        if (o instanceof VersionInfo) {
            VersionInfo otherVersion = o;
            return this.getCreationTime().compareTo(otherVersion.getCreationTime());
        }
        return 0;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof VersionInfo) {
            VersionInfo otherVersion = (VersionInfo)o;
            return this.getName().equals(otherVersion.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

