/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperty;
import java.text.ParseException;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class WikiImportProperty
extends WikiPageProperty {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NAME = "WikiImport";

    private WikiImportProperty() {
    }

    public WikiImportProperty(String source) {
        this.set("Source", source);
    }

    public String getSourceUrl() {
        return this.get("Source");
    }

    public boolean isRoot() {
        return this.has("IsRoot");
    }

    public void setRoot(boolean value) {
        if (value) {
            this.set("IsRoot");
        } else {
            this.remove("IsRoot");
        }
    }

    public boolean isAutoUpdate() {
        return this.has("AutoUpdate");
    }

    public void setAutoUpdate(boolean value) {
        if (value) {
            this.set("AutoUpdate");
        } else {
            this.remove("AutoUpdate");
        }
    }

    public static boolean isImported(PageData pageData) {
        try {
            WikiImportProperty importProperty = WikiImportProperty.createFrom((WikiPageProperty)pageData.getProperties());
            return importProperty != null && !importProperty.isRoot();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static WikiImportProperty createFrom(WikiPageProperty property) {
        if (property.has("WikiImport")) {
            WikiImportProperty importProperty = new WikiImportProperty();
            WikiPageProperty rawImportProperty = property.getProperty("WikiImport");
            importProperty.set("Source", rawImportProperty.getProperty("Source"));
            importProperty.set("LastRemoteModification", rawImportProperty.getProperty("LastRemoteModification"));
            if (rawImportProperty.has("IsRoot")) {
                importProperty.set("IsRoot", rawImportProperty.getProperty("IsRoot"));
            }
            if (rawImportProperty.has("AutoUpdate")) {
                importProperty.set("AutoUpdate", rawImportProperty.getProperty("AutoUpdate"));
            }
            return importProperty;
        }
        return null;
    }

    public void addTo(WikiPageProperty rootProperty) {
        rootProperty.set("WikiImport", (WikiPageProperty)this);
    }

    public void setLastRemoteModificationTime(Date date) {
        this.set("LastRemoteModification", WikiImportProperty.getTimeFormat().format(date));
    }

    public Date getLastRemoteModificationTime() {
        Date date = new Date(0L);
        String strValue = this.get("LastRemoteModification");
        if (strValue != null) {
            try {
                date = WikiImportProperty.getTimeFormat().parse(strValue);
            }
            catch (ParseException e) {
                date = new Date(0L);
            }
        }
        return date;
    }

    public static void handleImportProperties(HtmlPage html, WikiPage page) {
        PageData pageData = page.getData();
        if (WikiImportProperty.isImported((PageData)pageData)) {
            html.setBodyClass("imported");
            WikiImportProperty importProperty = WikiImportProperty.createFrom((WikiPageProperty)pageData.getProperties());
            html.put("sourceUrl", (Object)importProperty.getSourceUrl());
        } else if (page instanceof ProxyPage) {
            html.setBodyClass("virtual");
        }
    }

    public static String makeRemoteEditQueryParameters() {
        return "responder=edit&amp;redirectToReferer=true&amp;redirectAction=importAndView";
    }
}

