/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Collapsible;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import fitnesse.wikitext.parser.WikiWord;
import util.Maybe;

public class Include
extends SymbolType
implements Rule,
Translation {
    private static final String[] setUpSymbols = new String[]{"COLLAPSE_SETUP"};

    public Include() {
        super("Include");
        this.wikiMatcher(new Matcher().startLineOrCell().string("!include"));
        this.wikiRule((Rule)this);
        this.htmlTranslation((Translation)this);
    }

    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        Symbol next = parser.moveNext(1);
        if (!next.isType(SymbolType.Whitespace)) {
            return Symbol.nothing;
        }
        next = parser.moveNext(1);
        String option = "";
        if (next.isType(SymbolType.Text) && next.getContent().startsWith("-")) {
            option = next.getContent();
            next = parser.moveNext(1);
            if (!next.isType(SymbolType.Whitespace)) {
                return Symbol.nothing;
            }
            next = parser.moveNext(1);
        }
        if (!next.isType(SymbolType.Text) && !next.isType((SymbolType)WikiWord.symbolType)) {
            return Symbol.nothing;
        }
        current.add(option).add(next);
        Maybe includedPage = parser.getPage().getNamedPage().findIncludedPage(next.getContent());
        if (includedPage.isNothing()) {
            current.add(new Symbol(SymbolType.Meta).add(includedPage.because()));
        } else {
            current.childAt(1).putProperty("WITH_EDIT", "true");
            ParsingPage included = option.equals("-setup") || option.equals("-teardown") ? parser.getPage() : parser.getPage().copyForNamedPage((SourcePage)includedPage.getValue());
            current.add("").add(Parser.make((ParsingPage)included, (String)((SourcePage)includedPage.getValue()).getContent()).parse());
            if (option.equals("-setup")) {
                current.evaluateVariables(setUpSymbols, parser.getVariableSource());
            }
        }
        return new Maybe((Object)current);
    }

    public String toTarget(Translator translator, Symbol symbol) {
        if (symbol.getChildren().size() < 4) {
            return translator.translate(symbol.childAt(2));
        }
        String option = symbol.childAt(0).getContent();
        if (option.equals("-seamless")) {
            return translator.translate(symbol.childAt(3));
        }
        String collapseState = this.stateForOption(option, symbol);
        String title = "Included page: " + translator.translate(symbol.childAt(1));
        return Collapsible.generateHtml((String)collapseState, (String)title, (String)translator.translate(symbol.childAt(3)));
    }

    private String stateForOption(String option, Symbol symbol) {
        return (option.equals("-setup") || option.equals("-teardown")) && symbol.getVariable("COLLAPSE_SETUP", "true").equals("true") || option.equals("-c") ? " closed" : "";
    }
}

