/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestRoot;
import org.junit.Test;

public class ImageTest {
    @Test
    public void scansImages() {
        ParserTestHelper.assertScansTokenType((String)"!img name", (String)"Image", (boolean)true);
    }

    @Test
    public void parsesImages() throws Exception {
        ParserTestHelper.assertParses((String)"!img name", (String)"SymbolList[Link[SymbolList[Text]]]");
        ParserTestHelper.assertParses((String)"!img http://name", (String)"SymbolList[Link[SymbolList[Text]]]");
        ParserTestHelper.assertParses((String)"!imgx name", (String)"SymbolList[Text, Whitespace, Text]");
        ParserTestHelper.assertParses((String)"!img-l name", (String)"SymbolList[Link[SymbolList[Text]]]");
        ParserTestHelper.assertParses((String)"!img-r name", (String)"SymbolList[Link[SymbolList[Text]]]");
    }

    @Test
    public void translatesImages() {
        ParserTestHelper.assertTranslatesTo((String)"!img name", (String)"<img src=\"name\"/>");
        ParserTestHelper.assertTranslatesTo((String)"!img http://name", (String)"<img src=\"http://name\"/>");
        ParserTestHelper.assertTranslatesTo((String)"!img-l name", (String)"<img src=\"name\" class=\"left\"/>");
        ParserTestHelper.assertTranslatesTo((String)"!img-r name", (String)"<img src=\"name\" class=\"right\"/>");
    }

    @Test
    public void imageWithWidth() throws Exception {
        ParserTestHelper.assertParses((String)"!img -w 640 name", (String)"SymbolList[Link[SymbolList[Text]]]");
        TestRoot root = new TestRoot();
        WikiPage testPage = root.makePage("ImagePage", "!img -w 640 name");
        ParserTestHelper.assertTranslatesTo((WikiPage)testPage, (String)"<img src=\"name\" width=\"640\"/>");
    }

    @Test
    public void imageWidthHandleMistyped() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage testPage = root.makePage("ImagePage", "!img -w name");
        ParserTestHelper.assertTranslatesTo((WikiPage)testPage, (String)"!img -w name");
        testPage = root.makePage("ImagePage", "!img -w nnn name");
        ParserTestHelper.assertTranslatesTo((WikiPage)testPage, (String)"<img src=\"name\" width=\"nnn\"/>");
        testPage = root.makePage("ImagePage", "!img -w N");
        ParserTestHelper.assertTranslatesTo((WikiPage)testPage, (String)"!img -w N");
        testPage = root.makePage("ImagePage", "'''!img -w N'''");
        ParserTestHelper.assertTranslatesTo((WikiPage)testPage, (String)"<b>!img -w N</b>");
    }

    @Test
    public void imageWithMargin() throws Exception {
        ParserTestHelper.assertParses((String)"!img -m 10 name", (String)"SymbolList[Link[SymbolList[Text]]]");
        TestRoot root = new TestRoot();
        WikiPage testPage = root.makePage("ImagePage", "!img -m 10 name");
        ParserTestHelper.assertTranslatesTo((WikiPage)testPage, (String)"<img src=\"name\" style=\"margin:10px 10px 10px 10px;\"/>");
    }

    @Test
    public void imageWithBorder() throws Exception {
        ParserTestHelper.assertParses((String)"!img -b 1 name", (String)"SymbolList[Link[SymbolList[Text]]]");
        TestRoot root = new TestRoot();
        WikiPage testPage = root.makePage("ImagePage", "!img -b 1 name");
        ParserTestHelper.assertTranslatesTo((WikiPage)testPage, (String)"<img src=\"name\" style=\"border:1px solid black;\"/>");
    }

    @Test
    public void imageWithMarginBorderWidth() throws Exception {
        ParserTestHelper.assertParses((String)"!img -b 1 name", (String)"SymbolList[Link[SymbolList[Text]]]");
        TestRoot root = new TestRoot();
        WikiPage testPage = root.makePage("ImagePage", "!img -m 5 -b 1 -w 50 name");
        ParserTestHelper.assertTranslatesTo((WikiPage)testPage, (String)"<img src=\"name\" width=\"50\" style=\"border:1px solid black;margin:5px 5px 5px 5px;\"/>");
    }
}

