/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wikitext.test.ParserTestHelper;
import org.junit.Test;

public class ListTest {
    @Test
    public void scansLists() {
        ParserTestHelper.assertScansTokenType((String)" * item", (String)"UnorderedList", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)" *item", (String)"UnorderedList", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"  * item", (String)"UnorderedList", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"* item", (String)"UnorderedList", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)" 1 item", (String)"OrderedList", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"  9 item", (String)"OrderedList", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"1 item", (String)"OrderedList", (boolean)false);
    }

    @Test
    public void translatesUnorderedLists() {
        ParserTestHelper.assertTranslatesTo((String)" * item1\n * item2\n", (String)(this.list("ul", 0) + this.listItem("item1", 1) + this.listItem("item2", 1) + this.list("/ul", 0)));
    }

    @Test
    public void overridesNestedPairRule() {
        ParserTestHelper.assertTranslatesTo((String)" * item--1\n--", (String)(this.list("ul", 0) + this.listItem("item--1", 1) + this.list("/ul", 0) + "--"));
    }

    private String list(String tag, int level) {
        return this.indent(level) + "<" + tag + ">" + HtmlElement.endl;
    }

    private String listItem(String item, int level) {
        return this.indent(level) + "<li>" + item + "</li>" + HtmlElement.endl;
    }

    private String indent(int level) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            result.append("\t");
        }
        return result.toString();
    }

    @Test
    public void translatesNestedLists() {
        ParserTestHelper.assertTranslatesTo((String)" * item1\n  * item2\n  * item3\n", (String)(this.list("ul", 0) + this.listItem("item1" + this.list("ul", 0) + this.listItem("item2", 1) + this.listItem("item3", 1) + this.list("/ul", 0), 1) + this.list("/ul", 0)));
    }

    @Test
    public void translatesMultipleNestedLists() {
        ParserTestHelper.assertTranslatesTo((String)" * item1\n  * item11\n * item2\n  * item21\n", (String)(this.list("ul", 0) + this.listItem("item1" + this.list("ul", 0) + this.listItem("item11", 1) + this.list("/ul", 0), 1) + this.listItem("item2" + this.list("ul", 0) + this.listItem("item21", 1) + this.list("/ul", 0), 1) + this.list("/ul", 0)));
    }

    @Test
    public void translatesOrderedLists() {
        ParserTestHelper.assertTranslatesTo((String)" 1 item1\n 2 item2\n", (String)(this.list("ol", 0) + this.listItem("item1", 1) + this.listItem("item2", 1) + this.list("/ol", 0)));
    }

    @Test
    public void translatesNestedMixedLists() {
        ParserTestHelper.assertTranslatesTo((String)" * item1\n  1 item2\n", (String)(this.list("ul", 0) + this.listItem("item1" + this.list("ol", 0) + this.listItem("item2", 1) + this.list("/ol", 0), 1) + this.list("/ul", 0)));
    }
}

