/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental;

import org.junit.runner.Computer;
import org.junit.runner.Runner;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.RunnerScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ParallelComputer
extends Computer {
    private final boolean fClasses;
    private final boolean fMethods;

    public ParallelComputer(boolean classes, boolean methods) {
        this.fClasses = classes;
        this.fMethods = methods;
    }

    public static Computer classes() {
        return new ParallelComputer(true, false);
    }

    public static Computer methods() {
        return new ParallelComputer(false, true);
    }

    private static Runner parallelize(Runner runner) {
        if (runner instanceof ParentRunner) {
            ((ParentRunner)runner).setScheduler((RunnerScheduler)new /* Unavailable Anonymous Inner Class!! */);
        }
        return runner;
    }

    public Runner getSuite(RunnerBuilder builder, Class<?>[] classes) throws InitializationError {
        Runner suite = super.getSuite(builder, (Class[])classes);
        return this.fClasses ? ParallelComputer.parallelize((Runner)suite) : suite;
    }

    protected Runner getRunner(RunnerBuilder builder, Class<?> testClass) throws Throwable {
        Runner runner = super.getRunner(builder, testClass);
        return this.fMethods ? ParallelComputer.parallelize((Runner)runner) : runner;
    }
}

