/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.theories.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.experimental.theories.DataPoint;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.FromDataPoints;
import org.junit.experimental.theories.ParameterSignature;
import org.junit.experimental.theories.internal.AllMembersSupplier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecificDataPointsSupplier
extends AllMembersSupplier {
    public SpecificDataPointsSupplier(TestClass testClass) {
        super(testClass);
    }

    protected Collection<Field> getSingleDataPointFields(ParameterSignature sig) {
        Collection fields = super.getSingleDataPointFields(sig);
        String requestedName = ((FromDataPoints)sig.getAnnotation(FromDataPoints.class)).value();
        ArrayList<Field> fieldsWithMatchingNames = new ArrayList<Field>();
        for (Field field : fields) {
            String[] fieldNames = field.getAnnotation(DataPoint.class).value();
            if (!Arrays.asList(fieldNames).contains(requestedName)) continue;
            fieldsWithMatchingNames.add(field);
        }
        return fieldsWithMatchingNames;
    }

    protected Collection<Field> getDataPointsFields(ParameterSignature sig) {
        Collection fields = super.getDataPointsFields(sig);
        String requestedName = ((FromDataPoints)sig.getAnnotation(FromDataPoints.class)).value();
        ArrayList<Field> fieldsWithMatchingNames = new ArrayList<Field>();
        for (Field field : fields) {
            String[] fieldNames = field.getAnnotation(DataPoints.class).value();
            if (!Arrays.asList(fieldNames).contains(requestedName)) continue;
            fieldsWithMatchingNames.add(field);
        }
        return fieldsWithMatchingNames;
    }

    protected Collection<FrameworkMethod> getSingleDataPointMethods(ParameterSignature sig) {
        Collection methods = super.getSingleDataPointMethods(sig);
        String requestedName = ((FromDataPoints)sig.getAnnotation(FromDataPoints.class)).value();
        ArrayList<FrameworkMethod> methodsWithMatchingNames = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod method : methods) {
            String[] methodNames = ((DataPoint)method.getAnnotation(DataPoint.class)).value();
            if (!Arrays.asList(methodNames).contains(requestedName)) continue;
            methodsWithMatchingNames.add(method);
        }
        return methodsWithMatchingNames;
    }

    protected Collection<FrameworkMethod> getDataPointsMethods(ParameterSignature sig) {
        Collection methods = super.getDataPointsMethods(sig);
        String requestedName = ((FromDataPoints)sig.getAnnotation(FromDataPoints.class)).value();
        ArrayList<FrameworkMethod> methodsWithMatchingNames = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod method : methods) {
            String[] methodNames = ((DataPoints)method.getAnnotation(DataPoints.class)).value();
            if (!Arrays.asList(methodNames).contains(requestedName)) continue;
            methodsWithMatchingNames.add(method);
        }
        return methodsWithMatchingNames;
    }
}

