/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.enforcer;

import java.io.File;
import java.util.List;
import jdepend.framework.JDepend;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.scijava.maven.plugin.enforcer.EnforcerRuleHelperMock;
import org.scijava.maven.plugin.enforcer.JDependMock;
import org.scijava.maven.plugin.enforcer.NoPackageCyclesRule;

public class NoPackageCyclesRuleTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private NoPackageCyclesRule rule;
    private JDependMock jdependMock;
    private EnforcerRuleHelperMock helper;

    @Before
    public void setUp() throws Exception {
        this.jdependMock = new JDependMock();
        this.rule = new NoPackageCyclesRuleMock();
        this.helper = new EnforcerRuleHelperMock();
        this.helper.setClassesDir(this.temporaryFolder.newFolder("classes"));
        this.helper.setTestClassesDir(this.temporaryFolder.newFolder("test-classes"));
    }

    @Test
    public void cacheId_IsEmpty() throws Exception {
        MatcherAssert.assertThat((Object)this.rule.getCacheId(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void isNot_cacheable() {
        MatcherAssert.assertThat((Object)this.rule.isCacheable(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void result_IsNotValid() {
        MatcherAssert.assertThat((Object)this.rule.isResultValid(null), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void execute_checkNotNecessary_ClassesDirNotFound() throws Exception {
        File nonExistentClassesFolder = new File(this.temporaryFolder.getRoot(), "non-existent-classes-dir");
        this.helper.setClassesDir(nonExistentClassesFolder);
        File nonExistentTestClassesFolder = new File(this.temporaryFolder.getRoot(), "non-existent-test-classes-dir");
        this.helper.setTestClassesDir(nonExistentTestClassesFolder);
        this.rule.execute((EnforcerRuleHelper)this.helper);
        List<String> infoLogs = this.helper.getLogMock().getInfo();
        MatcherAssert.assertThat(infoLogs, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)infoLogs.get(0), (Matcher)Matchers.is((Object)("Directory " + nonExistentClassesFolder.getAbsolutePath() + " could not be found.")));
        MatcherAssert.assertThat((Object)infoLogs.get(1), (Matcher)Matchers.is((Object)("Directory " + nonExistentTestClassesFolder.getAbsolutePath() + " could not be found.")));
        MatcherAssert.assertThat((Object)infoLogs.get(2), (Matcher)Matchers.is((Object)"No directories with classes to check for cycles found."));
    }

    @Test
    public void execute_MavenEvaluationFailed_ThrowsException() throws Exception {
        this.helper.setEvaluateThrowsException(true);
        this.expectedException.expect(EnforcerRuleException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Unable to lookup an expression"));
        this.rule.execute((EnforcerRuleHelper)this.helper);
    }

    @Test
    public void execute_JdependAddDirectoryFailed_ThrowsException() throws Exception {
        this.jdependMock.setAddDirectoryThrowsException(true);
        this.expectedException.expect(EnforcerRuleException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Unable to access target directory"));
        this.rule.execute((EnforcerRuleHelper)this.helper);
    }

    @Test
    public void execute_ContainsNoCycles() throws Exception {
        this.rule.execute((EnforcerRuleHelper)this.helper);
        List<String> infoLogs = this.helper.getLogMock().getInfo();
        MatcherAssert.assertThat(infoLogs, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)infoLogs.get(0), (Matcher)Matchers.is((Object)("Adding directory " + this.classesFolder().getAbsolutePath() + " for package cycles search.")));
        MatcherAssert.assertThat((Object)infoLogs.get(1), (Matcher)Matchers.is((Object)("Adding directory " + this.testClassesFolder().getAbsolutePath() + " for package cycles search.")));
    }

    @Test
    public void execute_CanExcludeTests() throws Exception {
        this.rule.setIncludeTests(false);
        this.rule.execute((EnforcerRuleHelper)this.helper);
        List<String> infoLogs = this.helper.getLogMock().getInfo();
        MatcherAssert.assertThat(infoLogs, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)infoLogs.get(0), (Matcher)Matchers.is((Object)("Adding directory " + this.classesFolder().getAbsolutePath() + " for package cycles search.")));
    }

    @Test
    public void execute_ContainsNoCyclesWithoutTestClasses() throws Exception {
        File nonExistentTestClassesDir = new File(this.temporaryFolder.getRoot(), "does not exist");
        this.helper.setTestClassesDir(nonExistentTestClassesDir);
        this.rule.execute((EnforcerRuleHelper)this.helper);
        List<String> infoLogs = this.helper.getLogMock().getInfo();
        MatcherAssert.assertThat(infoLogs, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)infoLogs.get(0), (Matcher)Matchers.is((Object)("Adding directory " + this.classesFolder().getAbsolutePath() + " for package cycles search.")));
        MatcherAssert.assertThat((Object)infoLogs.get(1), (Matcher)Matchers.is((Object)("Directory " + nonExistentTestClassesDir.getAbsolutePath() + " could not be found.")));
    }

    @Test
    public void execute_ContainsCycles() throws Exception {
        this.jdependMock.setContainsCycles(true);
        this.expectedException.expect(EnforcerRuleException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"There are package cycles"));
        this.rule.execute((EnforcerRuleHelper)this.helper);
    }

    private File testClassesFolder() {
        return new File(this.temporaryFolder.getRoot(), "test-classes");
    }

    private File classesFolder() {
        return new File(this.temporaryFolder.getRoot(), "classes");
    }

    private class NoPackageCyclesRuleMock
    extends NoPackageCyclesRule {
        private NoPackageCyclesRuleMock() {
        }

        protected JDepend createJDepend(EnforcerRuleHelper helper) {
            return NoPackageCyclesRuleTest.this.jdependMock;
        }
    }
}

