/*
 * Decompiled with CFR 0.152.
 */
package util;

import junit.framework.TestCase;
import util.GracefulNamer;

/*
 * Exception performing whole class analysis ignored.
 */
public class GracefulNamerTest
extends TestCase {
    public void testIsGracefulName() throws Exception {
        GracefulNamerTest.assertTrue((boolean)GracefulNamer.isGracefulName((String)"My Nice Fixture"));
        GracefulNamerTest.assertTrue((boolean)GracefulNamer.isGracefulName((String)"My_Nice Fixture"));
        GracefulNamerTest.assertTrue((boolean)GracefulNamer.isGracefulName((String)"My-Nice-Fixture"));
        GracefulNamerTest.assertTrue((boolean)GracefulNamer.isGracefulName((String)"My!Really#Crazy--Name^"));
        GracefulNamerTest.assertTrue((boolean)GracefulNamer.isGracefulName((String)"EndsWithADot."));
        GracefulNamerTest.assertFalse((boolean)GracefulNamer.isGracefulName((String)"MyNiceFixture"));
        GracefulNamerTest.assertFalse((boolean)GracefulNamer.isGracefulName((String)"my.package.Fixture"));
    }

    public void testUnGracefulName() throws Exception {
        GracefulNamerTest.assertEquals((String)"BadCompany", (String)GracefulNamer.disgrace((String)"Bad Company"));
        GracefulNamerTest.assertEquals((String)"BadCompany", (String)GracefulNamer.disgrace((String)"bad company"));
        GracefulNamerTest.assertEquals((String)"BadCompany", (String)GracefulNamer.disgrace((String)"Bad-Company"));
        GracefulNamerTest.assertEquals((String)"BadCompany", (String)GracefulNamer.disgrace((String)"Bad Company."));
        GracefulNamerTest.assertEquals((String)"BadCompany", (String)GracefulNamer.disgrace((String)"(Bad Company)"));
        GracefulNamerTest.assertEquals((String)"BadCompany", (String)GracefulNamer.disgrace((String)"BadCompany"));
        GracefulNamerTest.assertEquals((String)"Bad123Company", (String)GracefulNamer.disgrace((String)"bad 123 company"));
        GracefulNamerTest.assertEquals((String)"Bad123Company", (String)GracefulNamer.disgrace((String)"bad 123company"));
        GracefulNamerTest.assertEquals((String)"Bad123Company", (String)GracefulNamer.disgrace((String)"   bad  \t123  company   "));
        GracefulNamerTest.assertEquals((String)"Bad123Company", (String)GracefulNamer.disgrace((String)"Bad123Company"));
        GracefulNamerTest.assertEquals((String)"MyNamespaceBad123Company", (String)GracefulNamer.disgrace((String)"My.Namespace.Bad123Company"));
    }

    public void testRegracingName() throws Exception {
        GracefulNamerTest.assertEquals((String)"Company", (String)GracefulNamer.regrace((String)"Company"));
        GracefulNamerTest.assertEquals((String)"Bad Company", (String)GracefulNamer.regrace((String)"BadCompany"));
        GracefulNamerTest.assertEquals((String)"Bad Company Two", (String)GracefulNamer.regrace((String)"BadCompanyTwo"));
        GracefulNamerTest.assertEquals((String)"Bad Company 123", (String)GracefulNamer.regrace((String)"BadCompany123"));
        GracefulNamerTest.assertEquals((String)"Bad 123 Company", (String)GracefulNamer.regrace((String)"Bad123Company"));
        GracefulNamerTest.assertEquals((String)"Bad 1a 2b 3 Company", (String)GracefulNamer.regrace((String)"Bad1a2b3Company"));
        GracefulNamerTest.assertEquals((String)"B 12z 3 Company", (String)GracefulNamer.regrace((String)"B12z3Company"));
        GracefulNamerTest.assertEquals((String)".Bad Company Two", (String)GracefulNamer.regrace((String)".BadCompanyTwo"));
        GracefulNamerTest.assertEquals((String)">Bad Company Two", (String)GracefulNamer.regrace((String)">BadCompanyTwo"));
        GracefulNamerTest.assertEquals((String)"<Bad Company Two", (String)GracefulNamer.regrace((String)"<BadCompanyTwo"));
        GracefulNamerTest.assertEquals((String)".Bad Company Two .Child Page", (String)GracefulNamer.regrace((String)".BadCompanyTwo.ChildPage"));
        GracefulNamerTest.assertEquals((String)">Bad Company Two .Child Page", (String)GracefulNamer.regrace((String)">BadCompanyTwo.ChildPage"));
        GracefulNamerTest.assertEquals((String)"<Bad Company Two .Child Page", (String)GracefulNamer.regrace((String)"<BadCompanyTwo.ChildPage"));
    }

    public void testEmptyString() throws Exception {
        GracefulNamerTest.assertEquals((String)"", (String)GracefulNamer.disgrace((String)""));
    }
}

