/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.meta;

import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.meta.POM;

public class POMTest {
    @Test
    public void testCompareVersions() {
        Assertions.assertTrue((POM.compareVersions((String)"1", (String)"2") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"1.0", (String)"2.0") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"1.0", (String)"1.1") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"1.0.0", (String)"2.0.0") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"2", (String)"1") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"2.0", (String)"1.0") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"1.1", (String)"1.0") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"2.0.0", (String)"1.0.0") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"1.0-RC1", (String)"1.0-RC2") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"1.0-RC-1", (String)"1.0-RC-2") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"1.0-RC-2", (String)"1.0-RC-10") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"0.4-alpha", (String)"0.4-beta") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"foo", (String)"bar") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"1.0-RC2", (String)"1.0-RC10") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"1.0-rc1", (String)"1.0-RC2") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"2.0.0", (String)"2.0.0.1") < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((POM.compareVersions((String)"2.0.0", (String)"2.0.0-beta-1") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAccessors() throws IOException {
        POM pom = new POM(new File("pom.xml"));
        Assertions.assertEquals((Object)"org.scijava", (Object)pom.parentGroupId());
        Assertions.assertNotNull((Object)pom.parentVersion());
        Assertions.assertEquals((Object)"org.scijava", (Object)pom.groupId());
        Assertions.assertEquals((Object)"scijava-meta", (Object)pom.artifactId());
        Assertions.assertNotNull((Object)pom.version());
        Assertions.assertEquals((Object)"GitHub Actions", (Object)pom.ciManagementSystem());
        String ciManagementURL = pom.ciManagementURL();
        Assertions.assertEquals((Object)"https://github.com/scijava/scijava/actions", (Object)ciManagementURL);
        Assertions.assertEquals((Object)"GitHub Issues", (Object)pom.issueManagementSystem());
        String issueManagementURL = pom.issueManagementURL();
        Assertions.assertEquals((Object)"https://github.com/scijava/scijava/issues", (Object)issueManagementURL);
        Assertions.assertEquals((Object)"SciJava", (Object)pom.organizationName());
        Assertions.assertEquals((Object)"https://scijava.org/", (Object)pom.organizationURL());
        Assertions.assertTrue((boolean)pom.path().endsWith("pom.xml"));
        Assertions.assertTrue((boolean)pom.projectDescription().startsWith("Utility functions to introspect metadata of SciJava libraries."));
        Assertions.assertEquals((Object)"2022", (Object)pom.projectInceptionYear());
        Assertions.assertEquals((Object)"SciJava Meta", (Object)pom.projectName());
        Assertions.assertEquals((Object)"https://github.com/scijava/scijava", (Object)pom.projectURL());
        String scmConnection = pom.scmConnection();
        Assertions.assertEquals((Object)"scm:git:https://github.com/scijava/scijava", (Object)scmConnection);
        String scmDeveloperConnection = pom.scmDeveloperConnection();
        Assertions.assertEquals((Object)"scm:git:git@github.com:scijava/scijava", (Object)scmDeveloperConnection);
        Assertions.assertNotNull((Object)pom.scmTag());
        Assertions.assertEquals((Object)"https://github.com/scijava/scijava", (Object)pom.scmURL());
    }

    @Test
    public void testCdata() throws IOException {
        POM pom = new POM(new File("pom.xml"));
        Assertions.assertEquals((Object)"repo", (Object)pom.cdata("//project/licenses/license/distribution"));
        Assertions.assertEquals((Object)"https://github.com/scijava/scijava", (Object)pom.cdata("//project/url"));
    }
}

