/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.api;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public interface OpRequest {
    public String name();

    public Type type();

    public Type outType();

    public Type[] argTypes();

    public String label();

    public boolean typesMatch(Type var1, Map<TypeVariable<?>, Type> var2);

    default public String requestString() {
        StringBuilder n = new StringBuilder((String)(this.name() == null ? "" : "Name: \"" + this.name() + "\", Types: "));
        n.append(this.type()).append("\n");
        n.append("Input Types: \n");
        for (Type arg : this.argTypes()) {
            n.append("\t\t* ");
            n.append(arg == null ? "" : arg.getTypeName());
            n.append("\n");
        }
        n.append("Output Type: \n");
        n.append("\t\t* ");
        n.append(this.outType() == null ? "" : this.outType().getTypeName());
        n.append("\n");
        return n.substring(0, n.length() - 1);
    }

    default public boolean requestEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpRequest other = (OpRequest)obj;
        if (!Objects.equals(this.name(), other.name())) {
            return false;
        }
        if (!Objects.equals(this.type(), other.type())) {
            return false;
        }
        if (!Objects.equals(this.outType(), other.outType())) {
            return false;
        }
        return Arrays.equals(this.argTypes(), other.argTypes());
    }

    default public int requestHashCode() {
        return Arrays.deepHashCode(new Object[]{this.name(), this.type(), this.outType(), this.argTypes()});
    }

    public static Type[] filterNulls(Type ... types) {
        return (Type[])Arrays.stream(types).filter(Objects::nonNull).toArray(Type[]::new);
    }

    public static void append(StringBuilder sb, String s) {
        if (s == null) {
            return;
        }
        if (sb.length() > 0) {
            sb.append("/");
        }
        sb.append(s);
    }
}

