/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Producer;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.spi.Op;
import org.scijava.ops.spi.OpClass;
import org.scijava.types.Nil;

public class OpPriorityTest
extends AbstractTestEnvironment {
    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new TestDouble()});
        ops.register(new Object[]{new TestFloat()});
    }

    @Test
    public void testOpPriority() {
        Producer testFunc = (Producer)ops.op("test.priority", (Nil)new Nil<Producer<Number>>(){}, new Nil[0], (Nil)new Nil<Number>(){});
        Number x = (Number)testFunc.create();
        Assertions.assertTrue((boolean)(x instanceof Double));
    }

    @OpClass(names="test.priority", priority=-100.0)
    private static final class TestFloat
    implements Producer<Number>,
    Op {
        private TestFloat() {
        }

        public Number create() {
            return new Float(0.0);
        }
    }

    @OpClass(names="test.priority", priority=100.0)
    private static final class TestDouble
    implements Producer<Number>,
    Op {
        private TestDouble() {
        }

        public Number create() {
            return new Double(0.0);
        }
    }
}

