/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.adapt.functional;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.OpBuilderTestOps;
import org.scijava.ops.engine.adapt.functional.InplacesToFunctions;
import org.scijava.ops.engine.copy.CopyOpCollection;
import org.scijava.ops.engine.create.CreateOpCollection;
import org.scijava.types.Nil;

public class InplaceToFunctionAdaptTest
extends AbstractTestEnvironment {
    @BeforeAll
    public static void AddNeededOps() {
        ops.register(new Object[]{new OpBuilderTestOps()});
        ops.register(new Object[]{new CreateOpCollection()});
        ops.register(new Object[]{new CopyOpCollection()});
        Object[] adapters = InplaceToFunctionAdaptTest.objsFromNoArgConstructors(InplacesToFunctions.class.getDeclaredClasses());
        ops.register(adapters);
    }

    @Test
    public void testInplace1_1ToFunction1() {
        double[] input = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2.0, 3.0};
        double[] output = (double[])ops.op("test.mulArrays1_1").input((Object)input).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace2_1ToFunction2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4.0, 9.0};
        double[] output = (double[])ops.op("test.mulArrays2_1").input((Object)input1, (Object)input2).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace2_2ToFunction2() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4.0, 9.0};
        double[] output = (double[])ops.op("test.mulArrays2_2").input((Object)input1, (Object)input2).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace3_1ToFunction3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8.0, 27.0};
        double[] output = (double[])ops.op("test.mulArrays3_1").input((Object)input1, (Object)input2, (Object)input3).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace3_2ToFunction3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8.0, 27.0};
        double[] output = (double[])ops.op("test.mulArrays3_2").input((Object)input1, (Object)input2, (Object)input3).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace3_3ToFunction3() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8.0, 27.0};
        double[] output = (double[])ops.op("test.mulArrays3_3").input((Object)input1, (Object)input2, (Object)input3).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace4_1ToFunction4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        double[] output = (double[])ops.op("test.mulArrays4_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace4_2ToFunction4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        double[] output = (double[])ops.op("test.mulArrays4_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace4_3ToFunction4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        double[] output = (double[])ops.op("test.mulArrays4_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace4_4ToFunction4() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16.0, 81.0};
        double[] output = (double[])ops.op("test.mulArrays4_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace5_1ToFunction5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        double[] output = (double[])ops.op("test.mulArrays5_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace5_2ToFunction5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        double[] output = (double[])ops.op("test.mulArrays5_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace5_3ToFunction5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        double[] output = (double[])ops.op("test.mulArrays5_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace5_4ToFunction5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        double[] output = (double[])ops.op("test.mulArrays5_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace5_5ToFunction5() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32.0, 243.0};
        double[] output = (double[])ops.op("test.mulArrays5_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace6_1ToFunction6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        double[] output = (double[])ops.op("test.mulArrays6_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace6_2ToFunction6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        double[] output = (double[])ops.op("test.mulArrays6_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace6_3ToFunction6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        double[] output = (double[])ops.op("test.mulArrays6_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace6_4ToFunction6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        double[] output = (double[])ops.op("test.mulArrays6_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace6_5ToFunction6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        double[] output = (double[])ops.op("test.mulArrays6_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace6_6ToFunction6() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 64.0, 729.0};
        double[] output = (double[])ops.op("test.mulArrays6_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace7_1ToFunction7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        double[] output = (double[])ops.op("test.mulArrays7_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace7_2ToFunction7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        double[] output = (double[])ops.op("test.mulArrays7_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace7_3ToFunction7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        double[] output = (double[])ops.op("test.mulArrays7_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace7_4ToFunction7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        double[] output = (double[])ops.op("test.mulArrays7_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace7_5ToFunction7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        double[] output = (double[])ops.op("test.mulArrays7_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace7_6ToFunction7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        double[] output = (double[])ops.op("test.mulArrays7_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace7_7ToFunction7() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 128.0, 2187.0};
        double[] output = (double[])ops.op("test.mulArrays7_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace8_1ToFunction8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        double[] output = (double[])ops.op("test.mulArrays8_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace8_2ToFunction8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        double[] output = (double[])ops.op("test.mulArrays8_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace8_3ToFunction8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        double[] output = (double[])ops.op("test.mulArrays8_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace8_4ToFunction8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        double[] output = (double[])ops.op("test.mulArrays8_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace8_5ToFunction8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        double[] output = (double[])ops.op("test.mulArrays8_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace8_6ToFunction8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        double[] output = (double[])ops.op("test.mulArrays8_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace8_7ToFunction8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        double[] output = (double[])ops.op("test.mulArrays8_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace8_8ToFunction8() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 256.0, 6561.0};
        double[] output = (double[])ops.op("test.mulArrays8_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace9_1ToFunction9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        double[] output = (double[])ops.op("test.mulArrays9_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace9_2ToFunction9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        double[] output = (double[])ops.op("test.mulArrays9_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace9_3ToFunction9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        double[] output = (double[])ops.op("test.mulArrays9_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace9_4ToFunction9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        double[] output = (double[])ops.op("test.mulArrays9_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace9_5ToFunction9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        double[] output = (double[])ops.op("test.mulArrays9_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace9_6ToFunction9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        double[] output = (double[])ops.op("test.mulArrays9_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace9_7ToFunction9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        double[] output = (double[])ops.op("test.mulArrays9_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace9_8ToFunction9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        double[] output = (double[])ops.op("test.mulArrays9_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace9_9ToFunction9() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 512.0, 19683.0};
        double[] output = (double[])ops.op("test.mulArrays9_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace10_1ToFunction10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        double[] output = (double[])ops.op("test.mulArrays10_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace10_2ToFunction10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        double[] output = (double[])ops.op("test.mulArrays10_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace10_3ToFunction10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        double[] output = (double[])ops.op("test.mulArrays10_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace10_4ToFunction10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        double[] output = (double[])ops.op("test.mulArrays10_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace10_5ToFunction10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        double[] output = (double[])ops.op("test.mulArrays10_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace10_6ToFunction10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        double[] output = (double[])ops.op("test.mulArrays10_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace10_7ToFunction10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        double[] output = (double[])ops.op("test.mulArrays10_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace10_8ToFunction10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        double[] output = (double[])ops.op("test.mulArrays10_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace10_9ToFunction10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        double[] output = (double[])ops.op("test.mulArrays10_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace10_10ToFunction10() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 1024.0, 59049.0};
        double[] output = (double[])ops.op("test.mulArrays10_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace11_1ToFunction11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        double[] output = (double[])ops.op("test.mulArrays11_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace11_2ToFunction11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        double[] output = (double[])ops.op("test.mulArrays11_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace11_3ToFunction11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        double[] output = (double[])ops.op("test.mulArrays11_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace11_4ToFunction11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        double[] output = (double[])ops.op("test.mulArrays11_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace11_5ToFunction11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        double[] output = (double[])ops.op("test.mulArrays11_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace11_6ToFunction11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        double[] output = (double[])ops.op("test.mulArrays11_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace11_7ToFunction11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        double[] output = (double[])ops.op("test.mulArrays11_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace11_8ToFunction11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        double[] output = (double[])ops.op("test.mulArrays11_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace11_9ToFunction11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        double[] output = (double[])ops.op("test.mulArrays11_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace11_10ToFunction11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        double[] output = (double[])ops.op("test.mulArrays11_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace11_11ToFunction11() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 2048.0, 177147.0};
        double[] output = (double[])ops.op("test.mulArrays11_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace12_1ToFunction12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        double[] output = (double[])ops.op("test.mulArrays12_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace12_2ToFunction12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        double[] output = (double[])ops.op("test.mulArrays12_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace12_3ToFunction12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        double[] output = (double[])ops.op("test.mulArrays12_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace12_4ToFunction12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        double[] output = (double[])ops.op("test.mulArrays12_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace12_5ToFunction12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        double[] output = (double[])ops.op("test.mulArrays12_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace12_6ToFunction12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        double[] output = (double[])ops.op("test.mulArrays12_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace12_7ToFunction12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        double[] output = (double[])ops.op("test.mulArrays12_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace12_8ToFunction12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        double[] output = (double[])ops.op("test.mulArrays12_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace12_9ToFunction12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        double[] output = (double[])ops.op("test.mulArrays12_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace12_10ToFunction12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        double[] output = (double[])ops.op("test.mulArrays12_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace12_11ToFunction12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        double[] output = (double[])ops.op("test.mulArrays12_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace12_12ToFunction12() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 4096.0, 531441.0};
        double[] output = (double[])ops.op("test.mulArrays12_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace13_1ToFunction13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        double[] output = (double[])ops.op("test.mulArrays13_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace13_2ToFunction13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        double[] output = (double[])ops.op("test.mulArrays13_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace13_3ToFunction13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        double[] output = (double[])ops.op("test.mulArrays13_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace13_4ToFunction13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        double[] output = (double[])ops.op("test.mulArrays13_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace13_5ToFunction13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        double[] output = (double[])ops.op("test.mulArrays13_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace13_6ToFunction13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        double[] output = (double[])ops.op("test.mulArrays13_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace13_7ToFunction13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        double[] output = (double[])ops.op("test.mulArrays13_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace13_8ToFunction13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        double[] output = (double[])ops.op("test.mulArrays13_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace13_9ToFunction13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        double[] output = (double[])ops.op("test.mulArrays13_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace13_10ToFunction13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        double[] output = (double[])ops.op("test.mulArrays13_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace13_11ToFunction13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        double[] output = (double[])ops.op("test.mulArrays13_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace13_12ToFunction13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        double[] output = (double[])ops.op("test.mulArrays13_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace13_13ToFunction13() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 8192.0, 1594323.0};
        double[] output = (double[])ops.op("test.mulArrays13_13").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_1ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_2ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_3ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_4ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_5ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_6ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_7ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_8ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_9ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_10ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_11ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_12ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_13ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_13").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace14_14ToFunction14() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 16384.0, 4782969.0};
        double[] output = (double[])ops.op("test.mulArrays14_14").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_1ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_2ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_3ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_4ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_5ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_6ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_7ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_8ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_9ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_10ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_11ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_12ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_13ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_13").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_14ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_14").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace15_15ToFunction15() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 32768.0, 1.4348907E7};
        double[] output = (double[])ops.op("test.mulArrays15_15").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_1ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_1").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_2ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_2").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_3ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_3").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_4ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_4").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_5ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_5").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_6ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_6").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_7ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_7").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_8ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_8").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_9ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_9").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_10ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_10").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_11ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_11").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_12ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_12").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_13ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_13").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_14ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_14").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_15ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_15").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    @Test
    public void testInplace16_16ToFunction16() {
        double[] input1 = new double[]{1.0, 2.0, 3.0};
        double[] input2 = new double[]{1.0, 2.0, 3.0};
        double[] input3 = new double[]{1.0, 2.0, 3.0};
        double[] input4 = new double[]{1.0, 2.0, 3.0};
        double[] input5 = new double[]{1.0, 2.0, 3.0};
        double[] input6 = new double[]{1.0, 2.0, 3.0};
        double[] input7 = new double[]{1.0, 2.0, 3.0};
        double[] input8 = new double[]{1.0, 2.0, 3.0};
        double[] input9 = new double[]{1.0, 2.0, 3.0};
        double[] input10 = new double[]{1.0, 2.0, 3.0};
        double[] input11 = new double[]{1.0, 2.0, 3.0};
        double[] input12 = new double[]{1.0, 2.0, 3.0};
        double[] input13 = new double[]{1.0, 2.0, 3.0};
        double[] input14 = new double[]{1.0, 2.0, 3.0};
        double[] input15 = new double[]{1.0, 2.0, 3.0};
        double[] input16 = new double[]{1.0, 2.0, 3.0};
        double[] expected = new double[]{1.0, 65536.0, 4.3046721E7};
        double[] output = (double[])ops.op("test.mulArrays16_16").input((Object)input1, (Object)input2, (Object)input3, (Object)input4, (Object)input5, (Object)input6, (Object)input7, (Object)input8, (Object)input9, (Object)input10, (Object)input11, (Object)input12, (Object)input13, (Object)input14, (Object)input15, (Object)input16).outType((Nil)new Nil<double[]>(){}).apply();
        Assertions.assertTrue((boolean)Arrays.equals(output, expected));
    }

    private OpBuilder name(String opName) {
        return ops.op(opName);
    }
}

