/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.eval;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.eval.DefaultEval;
import org.scijava.ops.engine.math.MathOpCollection;

public class EvalTest
extends AbstractTestEnvironment {
    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new DefaultEval()});
        ops.register(new Object[]{new MathOpCollection()});
    }

    @Test
    public void testMath() {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("a", 2);
        vars.put("b", 3);
        vars.put("c", 5);
        Functions.Arity3 evaluator = ops.op("expression.eval").input((Object)"a+c", (Object)ops, vars).function();
        Assertions.assertEquals((Object)7.0, (Object)evaluator.apply((Object)"a+c", (Object)ops, vars));
        Assertions.assertEquals((Object)3.0, (Object)evaluator.apply((Object)"c-a", (Object)ops, vars));
        Assertions.assertEquals((Object)6.0, (Object)evaluator.apply((Object)"a*b", (Object)ops, vars));
        Assertions.assertEquals((Object)2.5, (Object)evaluator.apply((Object)"c/a", (Object)ops, vars));
        Assertions.assertEquals((Object)1.0, (Object)evaluator.apply((Object)"c%a", (Object)ops, vars));
        Assertions.assertEquals((Object)17.0, (Object)evaluator.apply((Object)"a+b*c", (Object)ops, vars));
    }

    @Test
    public void testMathWithoutVars() {
        Object result = ops.op("expression.eval").input((Object)"5+2", (Object)ops).apply();
        Assertions.assertEquals((Object)7.0, (Object)result);
    }
}

