/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.discovery.Discoverer;
import org.scijava.discovery.ManualDiscoverer;
import org.scijava.function.Producer;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.InfoTree;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.api.OpInstance;
import org.scijava.ops.engine.InfoTreeGenerator;
import org.scijava.ops.engine.MatchingConditions;
import org.scijava.ops.engine.OpInfoGenerator;
import org.scijava.ops.engine.OpWrapper;
import org.scijava.ops.engine.impl.ComplicatedOp;
import org.scijava.ops.engine.impl.DefaultOpEnvironment;
import org.scijava.ops.engine.matcher.MatchingRoutine;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.types.Nil;

public class OpCachingTest
implements OpCollection {
    private OpEnvironment ops;
    @OpField(names="test.basicOp")
    public final Producer<String> basicOp = () -> "This Op should be cached";

    @BeforeEach
    public void setUp() {
        Discoverer serviceLoading = Discoverer.using(ServiceLoader::load).onlyFor(new Class[]{OpWrapper.class, MatchingRoutine.class, OpInfoGenerator.class, InfoTreeGenerator.class});
        ManualDiscoverer discoverer = new ManualDiscoverer();
        discoverer.register(new Object[]{new OpCachingTest()});
        discoverer.register(new Object[]{new ComplicatedOp()});
        this.ops = OpEnvironment.buildEmpty();
        this.ops.discoverUsing(new Discoverer[]{serviceLoading, discoverer});
    }

    private DefaultOpEnvironment getDefaultOpEnv() {
        OpEnvironment opEnv = this.ops;
        if (!(opEnv instanceof DefaultOpEnvironment)) {
            Assertions.fail((String)"OpCachingTest expects a DefaultOpEnvironment (since it is testing the caching behavior of that class).");
        }
        return (DefaultOpEnvironment)opEnv;
    }

    private Map<MatchingConditions, OpInstance<?>> getOpCache(DefaultOpEnvironment opEnv) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field cacheField = opEnv.getClass().getDeclaredField("opCache");
        cacheField.setAccessible(true);
        return (Map)cacheField.get(opEnv);
    }

    @Test
    public void testCacheOp() throws SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        DefaultOpEnvironment defOpEnv = this.getDefaultOpEnv();
        Producer op = defOpEnv.op("test.basicOp").outType(String.class).producer();
        Map<MatchingConditions, OpInstance<?>> opCache = this.getOpCache(defOpEnv);
        OpInstance<?> cachedInstance = opCache.values().iterator().next();
        Assertions.assertEquals((float)opCache.size(), (float)1.0f, (float)0.0f);
        Assertions.assertEquals(this.basicOp, (Object)cachedInstance.op(), (String)"Object in cache was not the same Object that was returned!");
        MatchingConditions cachedConditions = opCache.keySet().iterator().next();
        String newString = "This Op invaded the cache!";
        Producer newProducer = () -> newString;
        OpInstance invaderInstance = OpInstance.of((Object)newProducer, (InfoTree)cachedInstance.infoTree(), (Type)new Nil<Producer<String>>(){}.type());
        opCache.replace(cachedConditions, invaderInstance);
        Producer invadedOp = defOpEnv.op("test.basicOp").outType(String.class).producer();
        Assertions.assertEquals((Object)newProducer.create(), (Object)invadedOp.create(), (String)"Op returned did not match the Op inserted into the cache!");
    }

    @Test
    public void cacheOpAndDependencies() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        DefaultOpEnvironment defOpEnv = this.getDefaultOpEnv();
        Producer op = defOpEnv.op("test.complicatedOp").outType(String.class).producer();
        Map<MatchingConditions, OpInstance<?>> opCache = this.getOpCache(defOpEnv);
        Assertions.assertEquals((float)opCache.size(), (float)2.0f, (float)0.0f);
        Optional<MatchingConditions> complicatedOptional = opCache.keySet().stream().filter(condition -> condition.request().name().equals("test.complicatedOp")).findFirst();
        Assertions.assertFalse((boolean)complicatedOptional.isEmpty(), (String)"test.complicatedOp not in cache!");
        Assertions.assertTrue((boolean)(opCache.get(complicatedOptional.get()).op() instanceof ComplicatedOp), (String)"Object in cache was not an instance of ComplicatedOp!");
        Optional<MatchingConditions> basicOptional = opCache.keySet().stream().filter(condition -> condition.request().name().equals("test.basicOp")).findFirst();
        Assertions.assertFalse((boolean)basicOptional.isEmpty(), (String)"test.basicOp not in cache despite being an OpDependency of test.complicatedOp");
        Assertions.assertEquals((Object)opCache.get(basicOptional.get()).op(), this.basicOp, (String)"Object in cache was not the same Object that was returned!");
    }

    @Test
    public void testHintOmitsCaching() throws Exception {
        DefaultOpEnvironment defOpEnv = this.getDefaultOpEnv();
        Map<MatchingConditions, OpInstance<?>> opCache = this.getOpCache(defOpEnv);
        opCache.clear();
        Hints h = new Hints(new String[]{"cache.IGNORE"});
        Producer op = defOpEnv.op("test.complicatedOp", h).outType(String.class).producer();
        Assertions.assertEquals((float)opCache.size(), (float)0.0f, (float)0.0f);
    }

    @Test
    public void testHintOmitsCacheRetrieval() throws Exception {
        DefaultOpEnvironment defOpEnv = this.getDefaultOpEnv();
        Producer op = defOpEnv.op("test.basicOp").outType(String.class).producer();
        Map<MatchingConditions, OpInstance<?>> opCache = this.getOpCache(defOpEnv);
        OpInstance<?> cachedInstance = opCache.values().iterator().next();
        Assertions.assertEquals((float)opCache.size(), (float)1.0f, (float)0.0f);
        Assertions.assertEquals(this.basicOp, (Object)cachedInstance.op(), (String)"Object in cache was not the same Object that was returned!");
        MatchingConditions cachedConditions = opCache.keySet().iterator().next();
        String newString = "This Op invaded the cache!";
        Producer newProducer = () -> newString;
        OpInstance invaderInstance = OpInstance.of((Object)newProducer, (InfoTree)cachedInstance.infoTree(), (Type)new Nil<Producer<String>>(){}.type());
        opCache.replace(cachedConditions, invaderInstance);
        Hints h = new Hints(new String[]{"cache.IGNORE"});
        op = defOpEnv.op("test.basicOp", h).outType(String.class).producer();
        Assertions.assertNotEquals((Object)op, (Object)cachedInstance.op(), (String)"Object in cache was the same Object that was returned!");
    }
}

