/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.convert;

import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.function.Inplaces;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.copy.CopyOpCollection;
import org.scijava.ops.engine.matcher.convert.IdentityCollection;
import org.scijava.ops.engine.matcher.convert.PrimitiveArrayConverters;
import org.scijava.ops.engine.matcher.convert.PrimitiveConverters;
import org.scijava.ops.engine.matcher.convert.UtilityConverters;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;

public class ConversionIOTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.math.square")
    public final Function<Double, Double> squareOp = in -> in * in;
    @OpField(names="test.math.square")
    public final Computers.Arity1<Double[], Double[]> squareArray = (in, out) -> {
        for (int i = 0; i < ((Double[])in).length && i < ((Double[])out).length; ++i) {
            out[i] = this.squareOp.apply(in[i]);
        }
    };
    @OpField(names="test.math.add")
    public final Inplaces.Arity2_1<Double[], Double[]> addArray1 = (io, in1) -> {
        for (int i = 0; i < ((Double[])io).length && i < ((Double[])in1).length; ++i) {
            Double[] doubleArray = io;
            int n = i;
            Double.valueOf(doubleArray[n] + in1[i]);
        }
    };
    @OpField(names="test.math.add")
    public final Inplaces.Arity2_2<Double[], Double[]> addArray2 = (in0, io) -> {
        for (int i = 0; i < ((Double[])io).length && i < ((Double[])in0).length; ++i) {
            Double[] doubleArray = io;
            int n = i;
            Double.valueOf(doubleArray[n] + in0[i]);
        }
    };

    @BeforeAll
    public static void AddNeededOps() {
        ops.register(new Object[]{new CopyOpCollection()});
        ops.register(new Object[]{new IdentityCollection()});
        ops.register(new Object[]{new PrimitiveConverters()});
        ops.register(new Object[]{new PrimitiveArrayConverters()});
        ops.register(new Object[]{new ConversionIOTest()});
        ops.register(new Object[]{new UtilityConverters()});
    }

    @Test
    public void testFunctionOutputConversion() {
        Integer in = 4;
        Integer square = (Integer)ops.op("test.math.square").input((Object)in).outType(Integer.class).apply();
        Assertions.assertEquals((double)square.intValue(), (double)16.0, (double)0.0);
    }

    @Test
    public void testBasicComputer() {
        Integer[] in = new Integer[]{1, 2, 3};
        Object[] out = new Integer[]{4, 5, 6};
        ops.op("test.math.square").input((Object)in).output((Object)out).compute();
        Assertions.assertArrayEquals((Object[])out, (Object[])new Integer[]{1, 4, 9});
    }

    @Test
    public void testBasicInplace2_1() {
        Object[] io = new Integer[]{1, 2, 3};
        Integer[] in1 = new Integer[]{4, 5, 6};
        Object[] expected = new Integer[]{5, 7, 9};
        ops.op("test.math.add").input((Object)io, (Object)in1).mutate1();
        Assertions.assertArrayEquals((Object[])io, (Object[])expected);
    }

    @Test
    public void testBasicInplace2_2() {
        Integer[] in0 = new Integer[]{4, 5, 6};
        Object[] io = new Integer[]{1, 2, 3};
        Object[] expected = new Integer[]{5, 7, 9};
        ops.op("test.math.add").input((Object)in0, (Object)io).mutate2();
        Assertions.assertArrayEquals((Object[])io, (Object[])expected);
    }
}

