/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.convert;

import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.matcher.convert.IdentityCollection;
import org.scijava.ops.engine.matcher.convert.UtilityConverters;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;

public class ConversionPathwayIgnoreTest
extends AbstractTestEnvironment
implements OpCollection {
    private static boolean COPIED = false;
    @OpField(names="test.a")
    public final Computers.Arity1<FocusedA, FocusedA> opA = (a1, o) -> o.set(a1.get() + 1);
    @OpField(names="engine.convert")
    public final Function<FocusedA, Simple> fromAConverter = a -> new Simple(a.get());
    @OpField(names="engine.convert")
    public final Function<FocusedB, Simple> fromBConverter = b -> new Simple(b.get());
    @OpField(names="engine.convert")
    public final Function<Simple, FocusedA> toAConverter = s -> new FocusedA(s.get());
    @OpField(names="engine.convert")
    public final Function<Simple, FocusedB> toBConverter = s -> new FocusedB(s.get());
    @OpField(names="engine.copy")
    public final Computers.Arity1<FocusedA, FocusedA> aCopier = (a1, a2) -> {
        COPIED = true;
        a2.set(a1.get());
    };
    @OpField(names="engine.copy")
    public final Computers.Arity1<FocusedB, FocusedB> bCopier = (b1, b2) -> {
        COPIED = true;
        b2.set(b1.get());
    };
    @OpField(names="engine.copy")
    public final Computers.Arity1<Simple, Simple> sCopier = (s1, s2) -> {
        COPIED = true;
        s2.set(s1.get());
    };

    @BeforeAll
    public static void AddNeededOps() {
        ops.register(new Object[]{new IdentityCollection()});
        ops.register(new Object[]{new UtilityConverters()});
        ops.register(new Object[]{new ConversionPathwayIgnoreTest()});
    }

    @BeforeEach
    public void reset() {
        COPIED = false;
    }

    @Test
    public void testPathwaysNotIgnored() {
        FocusedA in = new FocusedA(0);
        FocusedB out = new FocusedB(0);
        ops.op("test.a").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((int)1, (int)out.get());
        Assertions.assertTrue((boolean)COPIED);
    }

    @Test
    public void testPathwaysIgnored() {
        FocusedB in = new FocusedB(0);
        FocusedA out = new FocusedA(0);
        ops.op("test.a").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((int)1, (int)out.get());
        Assertions.assertFalse((boolean)COPIED);
    }

    public static class Simple
    extends Base {
        public Simple(int x) {
            super(x);
        }
    }

    public static class FocusedB
    extends Base {
        public FocusedB(int x) {
            super(x);
        }
    }

    public static class FocusedA
    extends Base {
        public FocusedA(int x) {
            super(x);
        }
    }

    public static abstract class Base {
        int x;

        public Base(int x) {
            this.set(x);
        }

        public int get() {
            return this.x;
        }

        public void set(int x) {
            this.x = x;
        }
    }
}

