/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.convert;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.matcher.convert.IdentityCollection;
import org.scijava.ops.engine.matcher.convert.ListConverterCollection;
import org.scijava.ops.engine.matcher.convert.PrimitiveConverters;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.types.Nil;

public class PrimitiveListConverterTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.listConversion")
    public final Function<List<Integer>, List<Integer>> foo = in -> in.stream().map(i -> i * 2 + 1).collect(Collectors.toList());

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new PrimitiveListConverterTest(), new ListConverterCollection(), new PrimitiveConverters(), new IdentityCollection()});
    }

    @Test
    public void testLinkedListConverter() {
        Nil<List<Integer>> outNil = new Nil<List<Integer>>(){};
        List<Double> in = Arrays.asList(1.0, 2.0);
        List out = (List)ops.op("test.listConversion").input(in).outType((Nil)outNil).apply();
        for (int i = 0; i < in.size(); ++i) {
            Assertions.assertEquals((double)(in.get(i) * 2.0 + 1.0), (double)((Integer)out.get(i)).intValue());
        }
    }
}

