/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.adapt;

import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.ops.spi.OpCollection;
import org.scijava.types.Nil;

public class LiftFunctionsToImgTest
extends AbstractOpTest
implements OpCollection {
    public final Function<UnsignedByteType, UnsignedByteType> inc = in -> new UnsignedByteType(in.get() + 1);

    @Test
    public void testLiftingArity1() {
        ArrayImg<UnsignedByteType, ByteArray> foo = TestImgGeneration.unsignedByteArray(true, 10L, 10L, 10L);
        Img result = (Img)ops.op("test.liftFunctionToImg").input(foo).outType((Nil)new Nil<Img<UnsignedByteType>>(){}).apply();
        Cursor cursor = result.localizingCursor();
        RandomAccess fooRA = foo.randomAccess();
        while (cursor.hasNext()) {
            cursor.next();
            cursor.localize((Positionable)fooRA);
            Assertions.assertEquals((int)((UnsignedByteType)cursor.get()).get(), (int)((((UnsignedByteType)fooRA.get()).get() + 1) % 256));
        }
    }
}

