/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.create;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.img.planar.PlanarImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.MersenneTwisterFast;

public class CreateImgTest<T extends RealType<T>>
extends AbstractOpTest {
    private static final int TEST_SIZE = 100;
    private static final long SEED = 305419896L;

    @Test
    public void testImageMinimum() {
        MersenneTwisterFast randomGenerator = new MersenneTwisterFast(305419896L);
        for (int i = 0; i < 100; ++i) {
            long[] max = new long[randomGenerator.nextInt(4) + 2];
            long[] min = new long[max.length];
            for (int j = 0; j < max.length; ++j) {
                max[j] = randomGenerator.nextInt(9) + 2;
                min[j] = Math.max(0L, max[j] - (long)randomGenerator.nextInt(4));
            }
            Function createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.img", (Nil)new Nil<Interval>(){}, (Nil)new Nil<Img<?>>(){});
            Img img = (Img)createFunc.apply(new FinalInterval(min, max));
            Assertions.assertArrayEquals((long[])min, (long[])Intervals.minAsLongArray((Interval)img), (String)"Image Minimum:");
            Assertions.assertArrayEquals((long[])max, (long[])Intervals.maxAsLongArray((Interval)img), (String)"Image Maximum:");
        }
    }

    @Test
    public void testImageDimensions() {
        MersenneTwisterFast randomGenerator = new MersenneTwisterFast(305419896L);
        for (int i = 0; i < 100; ++i) {
            long[] dim = new long[randomGenerator.nextInt(4) + 2];
            for (int j = 0; j < dim.length; ++j) {
                dim[j] = randomGenerator.nextInt(9) + 2;
            }
            BiFunction createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.img", (Nil)new Nil<Dimensions>(){}, (Nil)new Nil<DoubleType>(){}, (Nil)new Nil<Img<DoubleType>>(){});
            Img img = (Img)createFunc.apply(new FinalDimensions(dim), new DoubleType());
            Assertions.assertArrayEquals((long[])dim, (long[])Intervals.dimensionsAsLongArray((Dimensions)img), (String)"Image Dimensions:");
        }
    }

    @Test
    public void testImgFromImg() {
        BiFunction createFuncDimsType = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.img", (Nil)new Nil<Dimensions>(){}, (Nil)new Nil<ByteType>(){}, (Nil)new Nil<Img<ByteType>>(){});
        Img img = (Img)createFuncDimsType.apply(new FinalDimensions(new int[]{1}), new ByteType());
        Function createFuncImg = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.img", (Nil)new Nil<Img<ByteType>>(){}, (Nil)new Nil<Img<ByteType>>(){});
        Img newImg = (Img)createFuncImg.apply(img);
        Assertions.assertEquals(((ByteType)img.firstElement()).getClass(), ((ByteType)newImg.firstElement()).getClass());
    }

    @Test
    public void testImageFactory() {
        FinalDimensions dim = new FinalDimensions(new int[]{10, 10, 10});
        Functions.Arity3 createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.img", (Nil)new Nil<Dimensions>(){}, (Nil)new Nil<DoubleType>(){}, (Nil)new Nil<ImgFactory<DoubleType>>(){}, (Nil)new Nil<Img<DoubleType>>(){});
        Img arrayImg = (Img)createFunc.apply((Object)dim, (Object)new DoubleType(), (Object)new ArrayImgFactory((NativeType)new DoubleType()));
        Class<?> arrayFactoryClass = arrayImg.factory().getClass();
        Assertions.assertEquals(ArrayImgFactory.class, arrayFactoryClass, (String)"Image Factory: ");
        Img cellImg = (Img)createFunc.apply((Object)dim, (Object)new DoubleType(), (Object)new CellImgFactory((NativeType)new DoubleType()));
        Class<?> cellFactoryClass = cellImg.factory().getClass();
        Assertions.assertEquals(CellImgFactory.class, cellFactoryClass, (String)"Image Factory: ");
    }

    @Test
    public void testImageType() {
        FinalDimensions dim = new FinalDimensions(new int[]{10, 10, 10});
        BiFunction createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.img", (Nil)new Nil<Dimensions>(){}, (Nil)new Nil<T>(){}, (Nil)new Nil<Img<T>>(){});
        Assertions.assertEquals(BitType.class, ((Img)createFunc.apply(dim, new BitType())).firstElement().getClass(), (String)"Image Type: ");
        Assertions.assertEquals(ByteType.class, ((Img)createFunc.apply(dim, new ByteType())).firstElement().getClass(), (String)"Image Type: ");
        Assertions.assertEquals(UnsignedByteType.class, ((Img)createFunc.apply(dim, new UnsignedByteType())).firstElement().getClass(), (String)"Image Type: ");
        Assertions.assertEquals(IntType.class, ((Img)createFunc.apply(dim, new IntType())).firstElement().getClass(), (String)"Image Type: ");
        Assertions.assertEquals(FloatType.class, ((Img)createFunc.apply(dim, new FloatType())).firstElement().getClass(), (String)"Image Type: ");
        Assertions.assertEquals(DoubleType.class, ((Img)createFunc.apply(dim, new DoubleType())).firstElement().getClass(), (String)"Image Type: ");
    }

    @Test
    public void testCreateFromImgSameType() {
        PlanarImg input = PlanarImgs.bytes((long[])new long[]{10L, 10L, 10L});
        BiFunction createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.img", (Nil)new Nil<Dimensions>(){}, (Nil)new Nil<ByteType>(){}, (Nil)new Nil<Img<ByteType>>(){});
        Img res = (Img)createFunc.apply(input, ((ByteType)input.firstElement()).createVariable());
        Assertions.assertEquals(ByteType.class, res.firstElement().getClass(), (String)"Image Type: ");
        Assertions.assertArrayEquals((long[])Intervals.dimensionsAsLongArray((Dimensions)input), (long[])Intervals.dimensionsAsLongArray((Dimensions)res), (String)"Image Dimensions: ");
        Assertions.assertEquals(input.factory().getClass(), res.factory().getClass(), (String)"Image Factory: ");
    }

    @Test
    public void testCreateFromImgDifferentType() {
        PlanarImg input = PlanarImgs.bytes((long[])new long[]{10L, 10L, 10L});
        BiFunction createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.img", (Nil)new Nil<Dimensions>(){}, (Nil)new Nil<ShortType>(){}, (Nil)new Nil<Img<ShortType>>(){});
        Img res = (Img)createFunc.apply(input, new ShortType());
        Assertions.assertEquals(ShortType.class, res.firstElement().getClass(), (String)"Image Type: ");
        Assertions.assertArrayEquals((long[])Intervals.dimensionsAsLongArray((Dimensions)input), (long[])Intervals.dimensionsAsLongArray((Dimensions)res), (String)"Image Dimensions: ");
        Assertions.assertEquals(input.factory().getClass(), res.factory().getClass(), (String)"Image Factory: ");
    }

    @Test
    public void testCreateFromRaiDifferentType() {
        IntervalView input = Views.interval((RandomAccessible)PlanarImgs.bytes((long[])new long[]{10L, 10L, 10L}), (Interval)new FinalInterval(new long[]{10L, 10L, 1L}));
        BiFunction createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.img", (Nil)new Nil<Dimensions>(){}, (Nil)new Nil<ShortType>(){}, (Nil)new Nil<Img<ShortType>>(){});
        Img res = (Img)createFunc.apply(input, new ShortType());
        Assertions.assertEquals(ShortType.class, res.firstElement().getClass(), (String)"Image Type: ");
        Assertions.assertArrayEquals((long[])Intervals.dimensionsAsLongArray((Dimensions)input), (long[])Intervals.dimensionsAsLongArray((Dimensions)res), (String)"Image Dimensions: ");
        Assertions.assertEquals(ArrayImgFactory.class, res.factory().getClass(), (String)"Image Factory: ");
    }

    @Test
    public void testCreateFromIntegerArray() {
        Integer[] dims = new Integer[]{25, 25, 10};
        Function createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.img", (Nil)new Nil<Integer[]>(){}, (Nil)new Nil<Img<?>>(){});
        Img res = (Img)createFunc.apply(dims);
        for (int i = 0; i < dims.length; ++i) {
            Assertions.assertEquals((long)dims[i].longValue(), (long)res.dimension(i), (String)("Image Dimension " + i + ": "));
        }
    }

    @Test
    public void testCreateFromLongArray() {
        Long[] dims = new Long[]{25L, 25L, 10L};
        Function createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.img", (Nil)new Nil<Long[]>(){}, (Nil)new Nil<Img<?>>(){});
        Img res = (Img)createFunc.apply(dims);
        for (int i = 0; i < dims.length; ++i) {
            Assertions.assertEquals((long)dims[i], (long)res.dimension(i), (String)("Image Dimension " + i + ": "));
        }
    }
}

