/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.create;

import java.util.stream.StreamSupport;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.real.DoubleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class CreateKernelDiffractionTest
extends AbstractOpTest {
    @Test
    public void testKernelDiffraction2D() {
        FinalDimensions dims = new FinalDimensions(new int[]{10, 10});
        double NA = 1.4;
        double lambda = 6.1E-7;
        double ns = 1.33;
        double ni = 1.5;
        double resLateral = 1.0E-7;
        double resAxial = 2.5E-7;
        double pZ = 2.0E-6;
        DoubleType type = new DoubleType();
        Functions.Arity9 createFunc = (Functions.Arity9)ops.op("create.kernelDiffraction", (Nil)new Nil<Functions.Arity9<Dimensions, Double, Double, Double, Double, Double, Double, Double, DoubleType, Img<DoubleType>>>(){}, new Nil[]{new Nil<Dimensions>(){}, new Nil<Double>(){}, new Nil<Double>(){}, new Nil<Double>(){}, new Nil<Double>(){}, new Nil<Double>(){}, new Nil<Double>(){}, new Nil<Double>(){}, new Nil<DoubleType>(){}}, (Nil)new Nil<Img<DoubleType>>(){});
        Img kernel = (Img)createFunc.apply((Object)dims, (Object)1.4, (Object)6.1E-7, (Object)1.33, (Object)1.5, (Object)1.0E-7, (Object)2.5E-7, (Object)2.0E-6, (Object)type);
        double[] expected = new double[]{0.03298495871588273, 0.04246786111102021, 0.0543588031627261, 0.06650574371357207, 0.07370280610722534, 0.07370280610722534, 0.06650574371357207, 0.0543588031627261, 0.04246786111102021, 0.03298495871588273, 0.04246786111102021, 0.05962205221267819, 0.08320071670150801, 0.10800022978800021, 0.1247473245002288, 0.1247473245002288, 0.10800022978800021, 0.08320071670150801, 0.05962205221267819, 0.04246786111102021, 0.0543588031627261, 0.08320071670150801, 0.1247473245002288, 0.1971468112729564, 0.2691722397359577, 0.2691722397359577, 0.1971468112729564, 0.1247473245002288, 0.08320071670150801, 0.0543588031627261, 0.06650574371357207, 0.10800022978800021, 0.1971468112729564, 0.40090474481128285, 0.6227157103102976, 0.6227157103102976, 0.40090474481128285, 0.1971468112729564, 0.10800022978800021, 0.06650574371357207, 0.07370280610722534, 0.1247473245002288, 0.2691722397359577, 0.6227157103102976, 1.0, 1.0, 0.6227157103102976, 0.2691722397359577, 0.1247473245002288, 0.07370280610722534, 0.07370280610722534, 0.1247473245002288, 0.2691722397359577, 0.6227157103102976, 1.0, 1.0, 0.6227157103102976, 0.2691722397359577, 0.1247473245002288, 0.07370280610722534, 0.06650574371357207, 0.10800022978800021, 0.1971468112729564, 0.40090474481128285, 0.6227157103102976, 0.6227157103102976, 0.40090474481128285, 0.1971468112729564, 0.10800022978800021, 0.06650574371357207, 0.0543588031627261, 0.08320071670150801, 0.1247473245002288, 0.1971468112729564, 0.2691722397359577, 0.2691722397359577, 0.1971468112729564, 0.1247473245002288, 0.08320071670150801, 0.0543588031627261, 0.04246786111102021, 0.05962205221267819, 0.08320071670150801, 0.10800022978800021, 0.1247473245002288, 0.1247473245002288, 0.10800022978800021, 0.08320071670150801, 0.05962205221267819, 0.04246786111102021, 0.03298495871588273, 0.04246786111102021, 0.0543588031627261, 0.06650574371357207, 0.07370280610722534, 0.07370280610722534, 0.06650574371357207, 0.0543588031627261, 0.04246786111102021, 0.03298495871588273};
        double[] actual = StreamSupport.stream(kernel.spliterator(), false).mapToDouble(t -> t.getRealDouble()).toArray();
        Assertions.assertArrayEquals((double[])expected, (double[])actual, (double)1.0E-6);
    }

    @Test
    public void testKernelDiffraction3D() {
        FinalDimensions dims = new FinalDimensions(new int[]{16, 16, 8});
        double NA = 1.4;
        double lambda = 6.1E-7;
        double ns = 1.33;
        double ni = 1.5;
        double resLateral = 1.0E-7;
        double resAxial = 2.5E-7;
        DoubleType type = new DoubleType();
        Functions.Arity9 createFunc = (Functions.Arity9)ops.op("create.kernelDiffraction", (Nil)new Nil<Functions.Arity9<Dimensions, Double, Double, Double, Double, Double, Double, Double, DoubleType, Img<DoubleType>>>(){}, new Nil[]{new Nil<Dimensions>(){}, new Nil<Double>(){}, new Nil<Double>(){}, new Nil<Double>(){}, new Nil<Double>(){}, new Nil<Double>(){}, new Nil<Double>(){}, new Nil<Double>(){}, new Nil<DoubleType>(){}}, (Nil)new Nil<Img<DoubleType>>(){});
        double pZ = 0.0;
        Img kernel = (Img)createFunc.apply((Object)dims, (Object)1.4, (Object)6.1E-7, (Object)1.33, (Object)1.5, (Object)1.0E-7, (Object)2.5E-7, (Object)0.0, (Object)type);
    }
}

