/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.create;

import java.util.function.BiFunction;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.util.Intervals;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.MersenneTwisterFast;

public class CreateLabelingTest
extends AbstractOpTest {
    private static final int TEST_SIZE = 100;
    private static final long SEED = 305419896L;

    @Test
    public void testImageDimensions() {
        MersenneTwisterFast randomGenerator = new MersenneTwisterFast(305419896L);
        BiFunction createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.imgLabeling", (Nil)new Nil<Dimensions>(){}, (Nil)new Nil<IntType>(){}, (Nil)new Nil<ImgLabeling<String, IntType>>(){});
        for (int i = 0; i < 100; ++i) {
            long[] dim = new long[randomGenerator.nextInt(4) + 2];
            for (int j = 0; j < dim.length; ++j) {
                dim[j] = randomGenerator.nextInt(9) + 2;
            }
            ImgLabeling img = (ImgLabeling)createFunc.apply(new FinalDimensions(dim), new IntType());
            Assertions.assertArrayEquals((long[])dim, (long[])Intervals.dimensionsAsLongArray((Dimensions)img), (String)"Labeling Dimensions:");
        }
    }

    @Test
    public void testImageFactory() {
        FinalDimensions dim = new FinalDimensions(new int[]{10, 10, 10});
        Functions.Arity3 createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.imgLabeling", (Nil)new Nil<Dimensions>(){}, (Nil)new Nil<IntType>(){}, (Nil)new Nil<ImgFactory<IntType>>(){}, (Nil)new Nil<ImgLabeling<String, IntType>>(){});
        Assertions.assertEquals(ArrayImgFactory.class, ((Img)((ImgLabeling)createFunc.apply((Object)dim, (Object)new IntType(), (Object)new ArrayImgFactory((NativeType)new IntType()))).getIndexImg()).factory().getClass(), (String)"Labeling Factory: ");
        Assertions.assertEquals(CellImgFactory.class, ((Img)((ImgLabeling)createFunc.apply((Object)dim, (Object)new IntType(), (Object)new CellImgFactory((NativeType)new IntType()))).getIndexImg()).factory().getClass(), (String)"Labeling Factory: ");
    }

    @Test
    public void testImageType() {
        Assertions.assertEquals(String.class, this.createLabelingWithType("1").firstElement().toArray()[0].getClass(), (String)"Labeling Type");
        Assertions.assertEquals(Integer.class, this.createLabelingWithType(1).firstElement().toArray()[0].getClass(), (String)"Labeling Type");
        Assertions.assertEquals(Double.class, this.createLabelingWithType(1.0).firstElement().toArray()[0].getClass(), (String)"Labeling Type");
        Assertions.assertEquals(Float.class, this.createLabelingWithType(Float.valueOf(1.0f)).firstElement().toArray()[0].getClass(), (String)"Labeling Type");
    }

    private <I> ImgLabeling<I, ?> createLabelingWithType(I type) {
        BiFunction createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.imgLabeling", (Nil)new Nil<Dimensions>(){}, (Nil)new Nil<IntType>(){}, (Nil)new Nil<ImgLabeling<I, IntType>>(){});
        ImgLabeling imgLabeling = (ImgLabeling)createFunc.apply(new FinalDimensions(new int[]{10, 10, 10}), new IntType());
        ((LabelingType)imgLabeling.cursor().next()).add(type);
        return imgLabeling;
    }
}

