/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter;

import net.imglib2.Cursor;
import net.imglib2.FinalDimensions;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.region.hypersphere.HyperSphere;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Pair;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class FFTTest
extends AbstractOpTest {
    private final boolean expensiveTestsEnabled = "enabled".equals(System.getProperty("scijava.ops.image.expensive.tests"));

    @Test
    public void testFFT3DOp() {
        int min = this.expensiveTestsEnabled ? 115 : 9;
        int max = this.expensiveTestsEnabled ? 120 : 11;
        for (int i = min; i < max; ++i) {
            long[] dimensions = new long[]{i, i, i};
            ArrayImg<FloatType, FloatArray> in = TestImgGeneration.floatArray(false, dimensions);
            this.placeSphereInCenter((Img<FloatType>)in);
            ArrayImg<FloatType, FloatArray> inverse = TestImgGeneration.floatArray(false, dimensions);
            RandomAccessibleInterval out = (RandomAccessibleInterval)ops.op("filter.fft").input(in, (Object)new ComplexFloatType()).outType((Nil)new Nil<RandomAccessibleInterval<ComplexFloatType>>(){}).apply();
            ops.op("filter.ifft").input((Object)out).output(inverse).compute();
            this.assertImagesEqual((Img<FloatType>)in, (Img<FloatType>)inverse, 5.0E-5f);
        }
    }

    @Test
    public void testFastFFT3DOp() {
        int min = this.expensiveTestsEnabled ? 120 : 9;
        int max = this.expensiveTestsEnabled ? 130 : 11;
        int size = this.expensiveTestsEnabled ? 129 : 10;
        for (int i = min; i < max; ++i) {
            long[] originalDimensions = new long[]{i, size, size};
            long[] fastDimensions = new long[3];
            long[] fftDimensions = new long[3];
            Pair fftSize = (Pair)ops.op("filter.fftSize").input((Object)new FinalDimensions(originalDimensions), (Object)fastDimensions, (Object)fftDimensions, (Object)true, (Object)true).outType((Nil)new Nil<Pair<long[], long[]>>(){}).apply();
            fastDimensions = (long[])fftSize.getA();
            fftDimensions = (long[])fftSize.getB();
            ArrayImg<FloatType, FloatArray> inOriginal = TestImgGeneration.floatArray(false, originalDimensions);
            this.placeSphereInCenter((Img<FloatType>)inOriginal);
            ArrayImg<FloatType, FloatArray> inFast = TestImgGeneration.floatArray(false, fastDimensions);
            this.placeSphereInCenter((Img<FloatType>)inFast);
            RandomAccessibleInterval fft1 = (RandomAccessibleInterval)ops.op("filter.fft").input(inOriginal, (Object)new ComplexFloatType(), null, (Object)false).outType((Nil)new Nil<RandomAccessibleInterval<ComplexFloatType>>(){}).apply();
            RandomAccessibleInterval fft2 = (RandomAccessibleInterval)ops.op("filter.fft").input(inOriginal, (Object)new ComplexFloatType()).outType((Nil)new Nil<RandomAccessibleInterval<ComplexFloatType>>(){}).apply();
            RandomAccessibleInterval fft3 = (RandomAccessibleInterval)ops.op("filter.fft").input(inFast, (Object)new ComplexFloatType()).outType((Nil)new Nil<RandomAccessibleInterval<ComplexFloatType>>(){}).apply();
            ArrayImg<FloatType, FloatArray> inverseOriginalSmall = TestImgGeneration.floatArray(false, originalDimensions);
            ArrayImg<FloatType, FloatArray> inverseOriginalFast = TestImgGeneration.floatArray(false, originalDimensions);
            ArrayImg<FloatType, FloatArray> inverseFast = TestImgGeneration.floatArray(false, fastDimensions);
            ops.op("filter.ifft").input((Object)fft1).output(inverseOriginalSmall).compute();
            ops.op("filter.ifft").input((Object)fft2).output(inverseOriginalFast).compute();
            ops.op("filter.ifft").input((Object)fft3).output(inverseFast).compute();
            this.assertImagesEqual((Img<FloatType>)inverseOriginalSmall, (Img<FloatType>)inOriginal, 1.0E-4f);
            this.assertImagesEqual((Img<FloatType>)inverseOriginalFast, (Img<FloatType>)inOriginal, 1.0E-5f);
            this.assertImagesEqual((Img<FloatType>)inverseFast, (Img<FloatType>)inFast, 1.0E-5f);
        }
    }

    @Test
    public void testPadShiftKernel() {
        long[] dims = new long[]{1024L, 1024L};
        Img test = (Img)ops.op("create.img").input((Object)new FinalDimensions(dims), (Object)new ComplexDoubleType()).outType((Nil)new Nil<Img<ComplexDoubleType>>(){}).apply();
        RandomAccessibleInterval shift = (RandomAccessibleInterval)ops.op("filter.padShiftKernel").input((Object)test, (Object)new FinalDimensions(dims)).outType((Nil)new Nil<RandomAccessibleInterval<ComplexDoubleType>>(){}).apply();
        RandomAccessibleInterval shift2 = (RandomAccessibleInterval)ops.op("filter.padShiftKernelFFTMethods").input((Object)test, (Object)new FinalDimensions(dims)).outType((Nil)new Nil<RandomAccessibleInterval<ComplexDoubleType>>(){}).apply();
        Assertions.assertEquals((long)1024L, (long)shift.dimension(0));
        Assertions.assertEquals((long)1120L, (long)shift2.dimension(0));
    }

    private void placeSphereInCenter(Img<FloatType> img) {
        Point center = new Point(img.numDimensions());
        for (int d = 0; d < img.numDimensions(); ++d) {
            center.setPosition(img.dimension(d) / 2L, d);
        }
        HyperSphere hyperSphere = new HyperSphere(img, (Localizable)center, 2L);
        for (FloatType value : hyperSphere) {
            value.setReal(1.0f);
        }
    }

    protected void assertImagesEqual(Img<FloatType> img1, Img<FloatType> img2, float delta) {
        Cursor c1 = img1.cursor();
        Cursor c2 = img2.cursor();
        while (c1.hasNext()) {
            c1.fwd();
            c2.fwd();
            Assertions.assertEquals((float)((FloatType)c1.get()).getRealFloat(), (float)((FloatType)c2.get()).getRealFloat(), (float)delta);
        }
    }

    protected void assertRAIsEqual(RandomAccessibleInterval<FloatType> rai1, RandomAccessibleInterval<FloatType> rai2, float delta) {
        IterableInterval rai1Iterator = Views.iterable(rai1);
        IterableInterval rai2Iterator = Views.iterable(rai2);
        Cursor c1 = rai1Iterator.cursor();
        Cursor c2 = rai2Iterator.cursor();
        while (c1.hasNext()) {
            c1.fwd();
            c2.fwd();
            Assertions.assertEquals((float)((FloatType)c1.get()).getRealFloat(), (float)((FloatType)c2.get()).getRealFloat(), (float)delta);
        }
    }

    protected void assertComplexImagesEqual(Img<ComplexFloatType> img1, Img<ComplexFloatType> img2, float delta) {
        Cursor c1 = img1.cursor();
        Cursor c2 = img2.cursor();
        while (c1.hasNext()) {
            c1.fwd();
            c2.fwd();
            Assertions.assertEquals((float)((ComplexFloatType)c1.get()).getRealFloat(), (float)((ComplexFloatType)c2.get()).getRealFloat(), (float)delta);
            Assertions.assertEquals((float)((ComplexFloatType)c1.get()).getImaginaryFloat(), (float)((ComplexFloatType)c2.get()).getImaginaryFloat(), (float)delta);
        }
    }
}

