/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.hessian;

import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.CompositeView;
import net.imglib2.view.composite.RealComposite;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class HessianFilterTest
extends AbstractOpTest {
    @Test
    public void test() {
        ArrayImg<FloatType, FloatArray> img = TestImgGeneration.floatArray(false, 50L, 50L);
        Cursor cursorImg = img.cursor();
        int counterX = 0;
        int counterY = 0;
        while (cursorImg.hasNext()) {
            if (counterX > 20 && counterX < 30 || counterY > 20 && counterY < 30) {
                ((FloatType)cursorImg.next()).setOne();
            } else {
                ((FloatType)cursorImg.next()).setZero();
            }
            if (++counterX % 50 == 0) {
                ++counterY;
            }
            if (counterX == 50) {
                counterX = 0;
            }
            if (counterY != 50) continue;
            counterY = 0;
        }
        CompositeIntervalView out = (CompositeIntervalView)ops.op("filter.hessian").input(img).outType((Nil)new Nil<CompositeIntervalView<FloatType, RealComposite<FloatType>>>(){}).apply();
        Cursor outCursor = Views.iterable((RandomAccessibleInterval)out).cursor();
        while (outCursor.hasNext()) {
            RealComposite values = (RealComposite)outCursor.next();
            Assertions.assertEquals((Object)values.get(1L), (Object)values.get(2L));
        }
        CompositeView.CompositeRandomAccess outRA = out.randomAccess();
        int[] positions = new int[]{20, 0, 21, 0, 19, 31, 19, 30};
        float[] valuesXX = new float[]{16.0f, -16.0f, 15.0f, 11.0f};
        float[] valuesXY = new float[]{0.0f, 0.0f, 1.0f, 3.0f};
        float[] valuesYY = new float[]{0.0f, 0.0f, 15.0f, 15.0f};
        FloatType type = ((FloatType)Util.getTypeFromInterval(img)).createVariable();
        int i = 0;
        int j = 0;
        while (i < positions.length - 1) {
            int[] pos = new int[]{positions[i], positions[i + 1]};
            outRA.setPosition(pos);
            type.set(valuesXX[j]);
            Assertions.assertEquals((Object)type, (Object)((RealComposite)outRA.get()).get(0L));
            outRA.setPosition(pos);
            type.set(valuesXY[j]);
            Assertions.assertEquals((Object)type, (Object)((RealComposite)outRA.get()).get(1L));
            outRA.setPosition(pos);
            type.set(valuesYY[j]);
            Assertions.assertEquals((Object)type, (Object)((RealComposite)outRA.get()).get(3L));
            i += 2;
            ++j;
        }
    }
}

