/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.watershed;

import java.util.HashSet;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.labeling.ConnectedComponents;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.Regions;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.MersenneTwisterFast;

public class WatershedSeededTest
extends AbstractOpTest {
    private static final long SEED = 305419896L;

    @Test
    public void test() {
        long[] dims = new long[]{15L, 30L};
        ArrayImg input = ArrayImgs.floats((long[])dims);
        MersenneTwisterFast random = new MersenneTwisterFast(305419896L);
        for (FloatType b : input) {
            b.setReal(random.nextDouble());
        }
        ArrayImg bits = ArrayImgs.bits((long[])dims);
        RandomAccess ra = bits.randomAccess();
        ra.setPosition(new int[]{0, 0});
        ((BitType)ra.get()).set(true);
        ra.setPosition(new int[]{4, 6});
        ((BitType)ra.get()).set(true);
        ra.setPosition(new int[]{10, 20});
        ((BitType)ra.get()).set(true);
        ImgLabeling labeledSeeds = (ImgLabeling)ops.op("labeling.cca").input((Object)bits, (Object)ConnectedComponents.StructuringElement.EIGHT_CONNECTED).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.testWithoutMask((RandomAccessibleInterval<FloatType>)input, (ImgLabeling<Integer, IntType>)labeledSeeds);
        this.testWithMask((RandomAccessibleInterval<FloatType>)input, (ImgLabeling<Integer, IntType>)labeledSeeds);
    }

    private void testWithoutMask(RandomAccessibleInterval<FloatType> in, ImgLabeling<Integer, IntType> seeds) {
        long[] dims = new long[in.numDimensions()];
        in.dimensions(dims);
        ArrayImg mask = ArrayImgs.bits((long[])dims);
        for (BitType b : mask) {
            b.setOne();
        }
        ImgLabeling out = (ImgLabeling)ops.op("image.watershed").input(in, seeds, (Object)true, (Object)false).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out, seeds, (RandomAccessibleInterval<BitType>)mask, false, false);
        ImgLabeling out2 = (ImgLabeling)ops.op("image.watershed").input(in, seeds, (Object)true, (Object)true).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out2, seeds, (RandomAccessibleInterval<BitType>)mask, true, false);
        ImgLabeling out3 = (ImgLabeling)ops.op("image.watershed").input(in, seeds, (Object)false, (Object)false).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out3, seeds, (RandomAccessibleInterval<BitType>)mask, false, false);
        ImgLabeling out4 = (ImgLabeling)ops.op("image.watershed").input(in, seeds, (Object)false, (Object)true).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out4, seeds, (RandomAccessibleInterval<BitType>)mask, true, false);
    }

    private void testWithMask(RandomAccessibleInterval<FloatType> in, ImgLabeling<Integer, IntType> seeds) {
        long[] dims = new long[in.numDimensions()];
        in.dimensions(dims);
        ArrayImg mask = ArrayImgs.bits((long[])dims);
        RandomAccess raMask = mask.randomAccess();
        for (BitType b : mask) {
            b.setZero();
        }
        for (int x = 0; x < 10; ++x) {
            int y = 0;
            while (y < 10) {
                raMask.setPosition(new int[]{x, y++});
                ((BitType)raMask.get()).setOne();
            }
        }
        ImgLabeling out = (ImgLabeling)ops.op("image.watershed").input(in, seeds, (Object)true, (Object)false, (Object)mask).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out, seeds, (RandomAccessibleInterval<BitType>)mask, false, true);
        ImgLabeling out2 = (ImgLabeling)ops.op("image.watershed").input(in, seeds, (Object)true, (Object)true, (Object)mask).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out2, seeds, (RandomAccessibleInterval<BitType>)mask, true, true);
        ImgLabeling out3 = (ImgLabeling)ops.op("image.watershed").input(in, seeds, (Object)false, (Object)false, (Object)mask).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out3, seeds, (RandomAccessibleInterval<BitType>)mask, false, true);
        ImgLabeling out4 = (ImgLabeling)ops.op("image.watershed").input(in, seeds, (Object)false, (Object)true, (Object)mask).outType((Nil)new Nil<ImgLabeling<Integer, IntType>>(){}).apply();
        this.assertResults(in, (ImgLabeling<Integer, IntType>)out4, seeds, (RandomAccessibleInterval<BitType>)mask, true, true);
    }

    private void assertResults(RandomAccessibleInterval<FloatType> in, ImgLabeling<Integer, IntType> out, ImgLabeling<Integer, IntType> seeds, RandomAccessibleInterval<BitType> mask, boolean withWatersheds, boolean smallMask) {
        Cursor curOut = out.cursor();
        RandomAccess raMask = mask.randomAccess();
        while (curOut.hasNext()) {
            curOut.fwd();
            raMask.setPosition((Localizable)curOut);
            if (((BitType)raMask.get()).get()) {
                Assertions.assertEquals((int)1, (int)((LabelingType)curOut.get()).size());
                continue;
            }
            Assertions.assertEquals((Object)true, (Object)((LabelingType)curOut.get()).isEmpty());
        }
        IterableRegion regions = Regions.iterable(mask);
        HashSet labelSet = new HashSet();
        for (LabelingType pixel : Regions.sample((IterableInterval)regions, out)) {
            labelSet.addAll(pixel);
        }
        Assertions.assertEquals((int)in.numDimensions(), (int)out.numDimensions());
        Assertions.assertEquals((long)in.dimension(0), (long)out.dimension(0));
        Assertions.assertEquals((long)in.dimension(1), (long)out.dimension(1));
        Assertions.assertEquals((int)(3 + (withWatersheds ? 1 : 0)), (int)(labelSet.size() + (smallMask ? 1 : 0)));
    }
}

