/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.imagemoments;

import java.util.Random;
import net.imglib2.Cursor;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.testutil.AssertClose;

public class ImageMomentsTest
extends AbstractOpTest {
    private static final int EPSILON_EXP = -8;
    private static Img<UnsignedByteType> img;

    @BeforeAll
    public static void createImg() {
        ArrayImg tmp = ArrayImgs.unsignedBytes((long[])new long[]{100L, 100L});
        Random rand = new Random(1234567890L);
        Cursor cursor = tmp.cursor();
        while (cursor.hasNext()) {
            ((UnsignedByteType)cursor.next()).set(rand.nextInt((int)((UnsignedByteType)tmp.firstElement()).getMaxValue()));
        }
        img = tmp;
    }

    @Test
    public void testMoments() {
        DoubleType moment00 = new DoubleType();
        ops.op("imageMoments.moment00").input(img).output((Object)moment00).compute();
        DoubleType moment10 = new DoubleType();
        ops.op("imageMoments.moment10").input(img).output((Object)moment10).compute();
        DoubleType moment01 = new DoubleType();
        ops.op("imageMoments.moment01").input(img).output((Object)moment01).compute();
        DoubleType moment11 = new DoubleType();
        ops.op("imageMoments.moment11").input(img).output((Object)moment11).compute();
        AssertClose.assertCloseEnough((double)1277534.0, (double)moment00.getRealDouble(), (int)-8, (String)"ImageMoments.Moment00");
        AssertClose.assertCloseEnough((double)6.3018047E7, (double)moment10.getRealDouble(), (int)-8, (String)"ImageMoments.Moment10");
        AssertClose.assertCloseEnough((double)6.3535172E7, (double)moment01.getRealDouble(), (int)-8, (String)"ImageMoments.Moment01");
        AssertClose.assertCloseEnough((double)3.12877962E9, (double)moment11.getRealDouble(), (int)-8, (String)"ImageMoments.Moment11");
    }

    @Test
    public void testCentralMoments() {
        AssertClose.assertCloseEnough((double)-5275876.956702709, (double)((DoubleType)ops.op("imageMoments.centralMoment11").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.CentralMoment11");
        AssertClose.assertCloseEnough((double)1.069446988026993E9, (double)((DoubleType)ops.op("imageMoments.centralMoment02").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.CentralMoment02");
        AssertClose.assertCloseEnough((double)1.0585772432642086E9, (double)((DoubleType)ops.op("imageMoments.centralMoment20").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.CentralMoment20");
        AssertClose.assertCloseEnough((double)5478324.271281064, (double)((DoubleType)ops.op("imageMoments.centralMoment12").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.CentralMoment12");
        AssertClose.assertCloseEnough((double)-2.163645568548715E8, (double)((DoubleType)ops.op("imageMoments.centralMoment21").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.CentralMoment21");
        AssertClose.assertCloseEnough((double)1.735560232991217E8, (double)((DoubleType)ops.op("imageMoments.centralMoment30").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.CentralMoment30");
        AssertClose.assertCloseEnough((double)-4.0994213161155105E8, (double)((DoubleType)ops.op("imageMoments.centralMoment03").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.CentralMoment03");
    }

    @Test
    public void testNormalizedCentralMoments() {
        AssertClose.assertCloseEnough((double)-3.2325832933879204E-6, (double)((DoubleType)ops.op("imageMoments.normalizedCentralMoment11").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.NormalizedCentralMoment11");
        AssertClose.assertCloseEnough((double)6.552610106398286E-4, (double)((DoubleType)ops.op("imageMoments.normalizedCentralMoment02").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.NormalizedCentralMoment02");
        AssertClose.assertCloseEnough((double)6.486010078361372E-4, (double)((DoubleType)ops.op("imageMoments.normalizedCentralMoment20").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.NormalizedCentralMoment20");
        AssertClose.assertCloseEnough((double)2.969727272701925E-9, (double)((DoubleType)ops.op("imageMoments.normalizedCentralMoment12").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.NormalizedCentralMoment12");
        AssertClose.assertCloseEnough((double)-1.1728837022440002E-7, (double)((DoubleType)ops.op("imageMoments.normalizedCentralMoment21").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.NormalizedCentralMoment21");
        AssertClose.assertCloseEnough((double)9.408242926327751E-8, (double)((DoubleType)ops.op("imageMoments.normalizedCentralMoment30").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.NormalizedCentralMoment30");
        AssertClose.assertCloseEnough((double)-2.22224218245127E-7, (double)((DoubleType)ops.op("imageMoments.normalizedCentralMoment03").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.NormalizedCentralMoment03");
    }

    @Test
    public void testHuMoments() {
        AssertClose.assertCloseEnough((double)0.001303862018475966, (double)((DoubleType)ops.op("imageMoments.huMoment1").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.HuMoment1");
        AssertClose.assertCloseEnough((double)8.615401633994056E-11, (double)((DoubleType)ops.op("imageMoments.huMoment2").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.HuMoment2");
        AssertClose.assertCloseEnough((double)2.406124306990366E-14, (double)((DoubleType)ops.op("imageMoments.huMoment3").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.HuMoment3");
        AssertClose.assertCloseEnough((double)1.246879188175627E-13, (double)((DoubleType)ops.op("imageMoments.huMoment4").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.HuMoment4");
        AssertClose.assertCloseEnough((double)-6.610443880647384E-27, (double)((DoubleType)ops.op("imageMoments.huMoment5").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.HuMoment5");
        AssertClose.assertCloseEnough((double)1.131019166855569E-18, (double)((DoubleType)ops.op("imageMoments.huMoment6").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.HuMoment6");
        AssertClose.assertCloseEnough((double)1.716256940536518E-27, (double)((DoubleType)ops.op("imageMoments.huMoment7").input(img).outType(DoubleType.class).apply()).getRealDouble(), (int)-8, (String)"ImageMoments.HuMoment7");
    }
}

