/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.linalg.rotate;

import org.joml.AxisAngle4d;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;

public class Rotate3dTest
extends AbstractOpTest {
    private static final Quaterniondc IDENTITY = new Quaterniond(1.0, 0.0, 0.0, 0.0);

    @Test
    public void testAxisAngle() {
        Vector3d xAxis = new Vector3d(1.0, 0.0, 0.0);
        Vector3d in = new Vector3d((Vector3dc)xAxis);
        AxisAngle4d axisAngle = new AxisAngle4d(1.5707963267948966, 0.0, 0.0, 1.0);
        Vector3d expected = xAxis.rotate((Quaterniondc)new Quaterniond(axisAngle));
        Vector3d result = (Vector3d)ops.op("linalg.rotate").input((Object)in, (Object)axisAngle).outType(Vector3d.class).apply();
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Rotation is incorrect");
    }

    @Test
    public void testCalculate() {
        Vector3d xAxis = new Vector3d(1.0, 0.0, 0.0);
        Vector3d in = new Vector3d((Vector3dc)xAxis);
        Vector3d result = (Vector3d)ops.op("linalg.rotate").input((Object)in, (Object)IDENTITY).outType(Vector3d.class).apply();
        Assertions.assertNotSame((Object)in, (Object)result, (String)"Op should create a new object for output");
        Assertions.assertEquals((Object)xAxis, (Object)result, (String)"Rotation is incorrect");
    }
}

